#' Example Log Return Time Series
#'
#' A tibble containing daily negative log returns of closing prices for the S&P 500 stock market index.
#' The observation period spans 20 trading years: 1995-01-01 to 2024-12-31.
#'
#' The data was obtained using the \code{quantmod} package with \strong{Yahoo Finance} as the source.
#'
#' @format A tibble with 7,550 rows and 2 columns:
#' \describe{
#'   \item{day}{Date of observation (class \code{Date})}
#'   \item{neg_log_ret}{Negative log return (numeric)}
#' }
#'
#' @usage data(logret_data)
#' @keywords datasets
"logret_data"


#' Example Log Return Time Series
#'
#' A tibble containing daily negative log returns of closing prices for the S&P500-stock market price index. The observation period spans 20 trading-years: 01/01/1995 - 31/12/2024.
#'
#' The data was obtained using the \code{quantmod} package and the source \textbf{Yahoo}.
#'


