% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbX_functions.R
\name{ezclean}
\alias{ezclean}
\title{Clean and Process Microbiome Data}
\usage{
ezclean(microbiome_data, metadata, level = "d")
}
\arguments{
\item{microbiome_data}{A string specifying the path to the microbiome data file.}

\item{metadata}{A string specifying the path to the metadata file.}

\item{level}{A string indicating the taxonomic level for filtering the data (e.g., "genus").}
}
\value{
A data frame containing the cleaned and merged dataset.
}
\description{
Processes microbiome and metadata files (e.g., 16S rRNA sequencing data) to produce an analysis-ready dataset.
Supports CSV, TXT, and 'Excel' file formats. This function validates file formats, reads the data,
and merges the datasets by the common column 'SampleID'. If a 'Taxonomy' column exists, the data
are filtered to include only rows matching the provided taxonomic level.
}
\examples{
\dontrun{
  mb  <- system.file("extdata", "microbiome.csv", package = "mbX")
  md  <- system.file("extdata", "metadata.csv",   package = "mbX")
  if (nzchar(mb) && nzchar(md)) {
    cleaned_data <- ezclean(mb, md, "g")
    head(cleaned_data)
  } else {
    message("Sample data files not found.")
  }
}

}
