% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_datetimes.R
\name{split_datetimes}
\alias{split_datetimes}
\alias{split_dates}
\title{Splits date(time) column(s) into multiple columns}
\usage{
split_datetimes(data, cols = NULL, class = c("character", "date"))

split_dates(data, cols = NULL)
}
\arguments{
\item{data}{input dataframe}

\item{cols}{set of columns to apply transformation to. If \code{NULL} will apply
to all POSIXt columns (for \code{\link[=split_datetimes]{split_datetimes()}}) or Date columns (for
\code{\link[=split_dates]{split_dates()}}).}

\item{class}{For \code{\link[=split_datetimes]{split_datetimes()}}. The desired output of the separate
"date" and "time" columns. \code{"character"} leaves the columns as character
vectors. \code{"date"} will reformat the date as a "Date" and the time as a
"POSIXct" object, with a dummy date appended to it. In \code{\link[=split_dates]{split_dates()}}, all
returned columns are integers.}
}
\value{
a dataframe
}
\description{
These functions can split the "date" and "time" components of POSIXt columns
and the "hour", "month", and "day" components of Date columns into multiple
columns.
}
\examples{
# split datetimes
data <- data.frame(today = Sys.time())
split_datetimes(data)
# split dates
data <- data.frame(today = Sys.Date())
data
split_dates(data)

}
\seealso{
Other Messy date(time) functions: 
\code{\link{messy_datetime_formats}()},
\code{\link{messy_datetime_tzones}()}
}
\author{
Jack Davison
}
\concept{Messy date(time) functions}
