% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_variability_from_dispersion.R
\name{es_variab_from_means_se}
\alias{es_variab_from_means_se}
\title{Convert means and/or standard errors of two independent groups into two effect measures (VR/CVR)}
\usage{
es_variab_from_means_se(
  mean_exp,
  mean_nexp,
  mean_se_exp,
  mean_se_nexp,
  n_exp,
  n_nexp,
  reverse_means_variability
)
}
\arguments{
\item{mean_exp}{mean of participants in the experimental/exposed group.}

\item{mean_nexp}{mean of participants in the non-experimental/non-exposed group.}

\item{mean_se_exp}{standard error of participants in the experimental/exposed group.}

\item{mean_se_nexp}{standard error of participants in the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{reverse_means_variability}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates VR and CVR

\tabular{ll}{
\code{natural effect size measure} \tab VR + CVR\cr
\tab \cr
\code{converted effect size measure} \tab No conversion performed\cr
\tab \cr
\code{required input data} \tab See 'Section 23. User's input (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert means and/or standard errors of two independent groups into two effect measures (VR/CVR)
}
\details{
This function converts the standard errors into standard deviations.
\deqn{mean\_sd\_exp = mean\_se\_exp * \sqrt{n\_exp - 1}}
\deqn{mean\_sd\_nexp = mean\_se\_nexp * \sqrt{n\_nexp - 1}}

Then, calculations of the \code{\link{es_variab_from_means_sd}} are applied.
}
\examples{
es_variab_from_means_se(
  mean_exp = 42, mean_se_exp = 11,
  mean_nexp = 42, mean_se_nexp = 15,
  n_exp = 43, n_nexp = 34
)
}
\references{
Senior, A. M., Viechtbauer, W., & Nakagawa, S. (2020). Revisiting and expanding the meta-analysis of variation: The log coefficient of variation ratio. Research Synthesis Methods, 11(4), 553-567. https://doi.org/10.1002/jrsm.1423
}
