% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Align Spectra}
\usage{
align(x, maxShift = 50, maxCombine = 5, verbose = TRUE, install_deps = NULL)
}
\arguments{
\item{x}{An object of  type  \code{decons1}  or  \code{decons2}  as  described  in  \href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.   To
align \code{decons0} objects (as returned by the now deprecated  \link{MetaboDecon1D}),
you can use \code{\link[=as_decons2]{as_decons2()}} to convert it to a \code{decons2} object first.}

\item{maxShift}{Maximum number of points along the "ppm-axis" a value can  be  moved  by  the
'speaq' package. 50 is a suitable starting value for plasma  spectra  with  a
digital resolution of 128K. Note that this parameter has to  be  individually
optimized  depending  on  the  type  of  analyzed  spectra  and  the  digital
resolution. For urine which is more prone to chemical shift  variations  this
value most probably has to be increased. Passed  as  argument  \code{maxShift}  to
\code{\link[=speaq_align]{speaq_align()}}.}

\item{maxCombine}{Amount of adjacent columns which may be combined for improving the alignment.
Passed as argument \code{range} to \code{\link[=combine_peaks]{combine_peaks()}}.}

\item{verbose}{Whether to print additional information during the alignment process.}

\item{install_deps}{Alignment  relies  on  the  'speaq'  package,  which  itself  relies  on  the
'MassSpecWavelet' and 'impute' packages. Both, 'MassSpecWavelet' and 'impute'
are   not   available    on    CRAN,    but    can    be    installed    from
\href{https://www.bioconductor.org/}{Bioconductor}                              or
\href{https://r-universe.dev/}{R-Universe}. If \code{install_deps=TRUE}, these packages
will  be  automatically  installed  from  R-Universe   without   asking   for
confirmation. If \code{install_deps=NULL} (default), the user will  be  asked  for
confirmation  before  installing  missing   dependencies.   If   asking   for
confirmation is not possible or \code{install_deps=FALSE}, the function will raise
an error if the packages are not installed.}
}
\value{
An object of type \code{align} as described in \href{https://spang-lab.github.io/metabodecon/articles/Classes.html}{Metabodecon Classes}.
}
\description{
Align signals across  a  list  of  deconvoluted  spectra  using  the  'CluPA'
algorithm from the 'speaq' package, described  in  Beirnaert  et  al.  (2018)
\url{doi:10.1371/journal.pcbi.1006018}     and     Vu     et      al.      (2011)
\url{doi:10.1186/1471-2105-12-405} plus the additional peak combination described
in \code{\link[=combine_peaks]{combine_peaks()}}.
}
\examples{
if (interactive()) {
    # Example requires an interactive R session, because in case of missing
    # dependencies the user will be asked for confirmation to install them.
    decons <- deconvolute(sim[1:2], sfr = c(3.55, 3.35))
    aligned <- align(decons)
}
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
