% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdrb.R
\name{check_mdrb}
\alias{check_mdrb}
\alias{check_mdrb_deps}
\title{Check Rust Backend Requirements}
\usage{
check_mdrb(stop_on_fail = FALSE)

check_mdrb_deps(verbose = FALSE)
}
\arguments{
\item{stop_on_fail}{If TRUE, an error is thrown if the check fails, providing instructions on how
to install or upgrade mdrb.}

\item{verbose}{If TRUE, additional information is printed during the check process.}
}
\value{
\code{check_mdrb()} returns TRUE if a suitable version of mdrb is installed,
else FALSE.

\code{check_mdrb_deps()} returns a data.frame as follows:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{            check           passed  comment
    r       R >= 4.2        TRUE    Current: R 4.4.2
    rtools  Rtools exist    TRUE    Tested with: pkgbuild::has_build_tools()
    cargo   cargo >= 1.80   TRUE    Current: cargo 1.84.1 (66221abde 2024-11-19)
    rustc   rustc >= 1.80   TRUE    Current: rustc 1.84.1 (e71f9a9a9 2025-01-27)
}\if{html}{\out{</div>}}

Column \code{check} is a string describing the performed check.\cr
Column \code{passed} is a boolean indicating whether the check passed.\cr
Column \code{comment} is a string string describing the check result.

The rownames of the dataframe one-word descriptions of the performed checks.
}
\description{
\code{check_mdrb()} returns a boolean indicating whether a suitable version of the
metabodecon Rust backend \href{https://github.com/spang-lab/mdrb}{mdrb} is
currently installed.

\code{check_mdrb_deps()} returns a list with information about the
installation status of mdrb system dependencies.
}
\examples{
check_mdrb()

\donttest{
# Checking dependencies might take more than 5 seconds, as it
# requires the compilation of a small test program as well as
# running `cargo --version` and `rustc --version`, which,
# depending on your system, might involve updating or installing
# Rust toolchain components.
check_mdrb_deps(verbose = TRUE)
}
}
\author{
2024-2025 Tobias Schmidt: initial version.
}
