% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preselect.R
\name{preselect}
\alias{preselect}
\title{Preselect variables for MetaForest analysis}
\usage{
preselect(x, replications = 100L, algorithm = "replicate", ...)
}
\arguments{
\item{x}{Model to perform variable selection for. Accepts MetaForest objects.}

\item{replications}{Integer. Number of replications to run for variable
preselection. Default: 100.}

\item{algorithm}{Character. Preselection method to apply. Currently,
'replicate', 'recursive', and 'bootstrap' are available.}

\item{...}{Other arguments to be passed to and from functions.}
}
\value{
An object of class 'mf_preselect'
}
\description{
Takes a \code{\link{MetaForest}} object, and applies different
algorithms for variable selection.
}
\details{
Currently, available methods under \code{algorithm} are:
\describe{
\item{replicate}{This simply replicates the analysis, which means the forest
has access to the full data set, but the trees are grown on different
bootstrap samples across replications (thereby varying monte carlo error).}
\item{bootstrap}{This replicates the analysis on bootstrapped samples, which
means each replication has access to a different sub-sample of the full data
set. When selecting this algorithm, cases are either bootstrap-sampled by
\code{study}, or a new \code{study} column is generated, and a clustered
MetaForest is grown (because some of the rows in the data will be duplicated)
, and this would lead to an under-estimation of the OOB error.}
\item{recursive}{Starting with all moderators, the variable with the most
negative variable importance is dropped from the model, and the analysis
re-run. This is repeated until only variables with a positive variable
importance are left, or no variables are left. The proportion of final models
containing each variable reflects its importance.}
}
}
\examples{
\dontrun{
data("dat.bourassa1996", package = "metadat")
df <- dat.bourassa1996
df <- escalc(measure = "OR", ai = lh.le, bi = lh.re, ci = rh.le, di= rh.re,
               data = df, add = 1/2, to = "all")
df$mage[is.na(df$mage)] <- median(df$mage, na.rm = TRUE)
df[c(5:8)] <- lapply(df[c(5:8)], factor)
df$yi <- as.numeric(df$yi)
mf.model <- MetaForest(formula = yi~ selection + investigator + hand_assess + eye_assess +
                        mage +sex,
          df, study = "sample",
          whichweights = "unif", num.trees = 300)
preselect(mf.model,
          replications = 10,
          algorithm = "bootstrap")
}
}
