% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.solutions_df}
\alias{plot.solutions_df}
\alias{plot.t_solutions_df}
\title{Plot of cluster assignments in a solutions data frame}
\usage{
\method{plot}{solutions_df}(
  x,
  y = NULL,
  cluster_rows = FALSE,
  cluster_columns = TRUE,
  heatmap_legend_param = NULL,
  row_title = "Solution",
  column_title = "Observation",
  ...
)

\method{plot}{t_solutions_df}(x, ...)
}
\arguments{
\item{x}{A \code{solutions_df} object.}

\item{y}{Optional argument to \code{plot}, not used in this method.}

\item{cluster_rows}{If the value is a logical, it controls whether to make cluster on rows. The value can also be a \code{\link[stats]{hclust}} or a \code{\link[stats]{dendrogram}} which already contains clustering. Check \url{https://jokergoo.github.io/ComplexHeatmap-reference/book/a-single-heatmap.html#clustering} .}

\item{cluster_columns}{Whether make cluster on columns? Same settings as \code{cluster_rows}.}

\item{heatmap_legend_param}{A list contains parameters for the heatmap legends. See \code{\link[ComplexHeatmap]{color_mapping_legend,ColorMapping-method}} for all available parameters.}

\item{row_title}{Title on the row.}

\item{column_title}{Title on the column.}

\item{...}{Additional arguments passed to \code{ComplexHeatmap::Heatmap()}.}
}
\value{
A \code{ComplexHeatmap::Heatmap()} object visualization of cluster
assignments.
}
\description{
This plot, built on \code{ComplexHeatmap::Heatmap()}, visualizes the cluster
assignments in a solutions data frame as a categorical heatmap with
observations along the columns and clusters along the rows.
}
