% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendly.R
\name{calendly_get}
\alias{calendly_get}
\title{Handle Calendly GET requests}
\usage{
calendly_get(url, token = NULL, user = NULL, count = NULL, page_token = NULL)
}
\arguments{
\item{url}{The endpoint URL for this API request}

\item{token}{You can provide the API key directly using this argument or this function will attempt to grab an API key that was stored using the `authorize("calendly")` function}

\item{user}{The user param for Calendly. Usually looks like "https://api.calendly.com/users/c208a750-9214-4c62-9ee6-a1a9507c7b43"}

\item{count}{For paginated GETs, you can specify how many things you'd like returned}

\item{page_token}{For a paginated GET, what page are we on?}
}
\value{
Calendly REST API response as a list
}
\description{
This is a function that handles Calendly GET requests
}
\examples{
\dontrun{

authorize("calendly")
token <- get_token(app_name = "calendly")

result_list <- calendly_get(
  url = "https://api.calendly.com/users/me",
  token = token
)
}

}
