% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{mfcurve_preprocessing}
\alias{mfcurve_preprocessing}
\title{Preprocess data and compute group statistics}
\usage{
mfcurve_preprocessing(data, outcome, factors, alpha = 0.05, test = "mean")
}
\arguments{
\item{data}{Data frame containing the variables.}

\item{outcome}{Name of the numeric outcome variable (string).}

\item{factors}{Character vector of factor variable names for grouping.}

\item{alpha}{Significance level for the t-tests and confidence intervals. Default is 0.05.}

\item{test}{Reference for t-tests: "mean" (grand mean), "leave-one-out" (mean of all other groups), or "zero" (testing against 0).}
}
\value{
A list with:
\describe{
\item{group_stats}{Data frame with computed statistics and CI bounds.}
\item{group_stats_vis}{Visualization-ready version with rounded values.}
\item{lower_data}{Data for the lower panel (without y positions).}
\item{grand_mean}{Overall mean of the outcome variable.}
\item{level}{Confidence level used.}
}
}
\description{
Prepares the data and computes descriptive statistics and t-tests
for groups defined by combinations of categorical factors.
}
