% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fciMI.R
\name{fciMI}
\alias{fciMI}
\title{Estimate a PAG by the FCI-MI Algorithm for Multiple Imputed Data Sets of Continuous Data}
\usage{
fciMI(
  data,
  alpha,
  labels,
  p,
  skel.method = c("stable", "original"),
  type = c("normal", "anytime", "adaptive"),
  fixedGaps = NULL,
  fixedEdges = NULL,
  NAdelete = TRUE,
  m.max = Inf,
  pdsep.max = Inf,
  rules = rep(TRUE, 10),
  doPdsep = TRUE,
  biCC = FALSE,
  conservative = FALSE,
  maj.rule = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{An object of type mids, which stands for 'multiply imputed
data set', typically created by a call to function mice()}

\item{alpha}{Significance level (number in (0,1) for the conditional
independence tests}

\item{labels}{(Optional) character vector of variable (or "node") names.
Typically preferred to specifying p.}

\item{p}{(Optional) number of variables (or nodes). May be specified if
labels are not, in which case labels is set to 1:p.}

\item{skel.method}{Character string specifying method; the default, "stable"
provides an order-independent skeleton, see \code{\link[pcalg:skeleton]{pcalg::skeleton()}} for details.}

\item{type}{Character string specifying the version of the FCI algorithm to be used.
See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{fixedGaps}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{fixedEdges}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{NAdelete}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{m.max}{Maximum size of the conditioning sets that are considered in
the conditional independence tests.}

\item{pdsep.max}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{rules}{Logical vector of length 10 indicating which rules should be
used when directing edges. The order of the rules is
taken from Zhang (2008).}

\item{doPdsep}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{biCC}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{conservative}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{maj.rule}{See \code{\link[pcalg:fci]{pcalg::fci()}} for details.}

\item{verbose}{If true, more detailed output is provided.}
}
\value{
See \code{\link[pcalg:fci]{pcalg::fci()}} for details.
}
\description{
This function is a modification of \code{\link[pcalg:fci]{pcalg::fci()}}
to be used for multiple imputation.
}
\examples{

daten <- windspeed[,1]
for(i in 2:ncol(windspeed)) daten <- c(daten, windspeed[,i])
daten[sample(1:length(daten), 260)] <- NA
daten <- matrix(daten, ncol = 6)

## Impute missing values
imp <- mice(daten, printFlag = FALSE)
fc.res <- fciMI(data = imp, label = colnames(imp$data), alpha = 0.01)

if (requireNamespace("Rgraphviz", quietly = TRUE))
plot(fc.res)


}
\author{
Original code by Diego Colombo, Markus Kalisch, and  Joris Mooij.
Modifications by Ronja Foraita.
}
