% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutatorGauss.R
\name{dict_mutators_gauss}
\alias{dict_mutators_gauss}
\alias{MutatorGauss}
\title{Gaussian Distribution Mutator}
\description{
Individuals are mutated with an independent normal random variable on each component.
}
\section{Configuration Parameters}{

\itemize{
\item \code{sdev} :: \code{numeric}\cr
Standard deviation of normal distribuion. This is absolute if \code{sdev_is_relative} is \code{FALSE}, and
multiplied with each individual component's range (upper - lower) if \code{sdev_is_relative} is \code{TRUE}.
This may either be a scalar, in which case it is applied to all input components, or a vector,
in which case it must have the length of the input and applies to components in order in which
they appear in the priming \code{\link[paradox:ParamSet]{ParamSet}}. Must be set by the user.
\item \code{sdev_is_relative} :: \code{logical(1)}\cr
Whether \code{sdev} is absolute (\code{FALSE}) or relative to component range (\code{TRUE}). Initialized to \code{FALSE}.
\item \code{truncated_normal} :: \code{logical(1)}\cr
Whether to draw individuals from a normal distribution that is truncated at the bounds of each
component (\code{TRUE}), or to draw from a normal distribution and then restrict to bounds afterwards
(\code{FALSE}). The former (\code{TRUE}) will lead to very few to no samples landing on the exact bounds
(analytically it would be none almost surely, but this is subject to machine precision), the latter
(\code{FALSE}) can lead to a substantial number of samples landing on the exact bounds. Initialized to \code{FALSE}.
}
}

\section{Supported Operand Types}{


Supported \code{\link[paradox:Domain]{Domain}} classes are: \code{\link[paradox:Domain]{p_int}} ('ParamInt'), \code{\link[paradox:Domain]{p_dbl}} ('ParamDbl')
}

\section{Dictionary}{

This \code{\link{Mutator}} can be created with the short access form \code{\link[=mut]{mut()}}
(\code{\link[=muts]{muts()}} to get a list), or through the the \link[mlr3misc:Dictionary]{dictionary}
\code{\link{dict_mutators}} in the following way:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# preferred:
mut("gauss")
muts("gauss")  # takes vector IDs, returns list of Mutators

# long form:
dict_mutators$get("gauss")
}\if{html}{\out{</div>}}
}

\examples{
set.seed(1)
mg = mut("gauss", sdev = 0.1)
p = ps(x = p_int(-5, 5), y = p_dbl(-5, 5))
data = data.frame(x = rep(0, 5), y = rep(0, 5))

mg$prime(p)
mg$operate(data)

mg$param_set$values$sdev = 100
mg$operate(data)
}
\seealso{
Other mutators: 
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}},
\code{\link{dict_mutators_unif}}
}
\concept{mutators}
\section{Super classes}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{\link[miesmuschel:Mutator]{miesmuschel::Mutator}} -> \code{\link[miesmuschel:MutatorNumeric]{miesmuschel::MutatorNumeric}} -> \code{MutatorGauss}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MutatorGauss-new}{\code{MutatorGauss$new()}}
\item \href{#method-MutatorGauss-clone}{\code{MutatorGauss$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorGauss-new"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorGauss-new}{}}}
\subsection{Method \code{new()}}{
Initialize the \code{MutatorGauss} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorGauss$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MutatorGauss-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MutatorGauss-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MutatorGauss$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
