% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mig_lscv}
\alias{mig_lscv}
\title{Least squares cross-validation for MIG density estimation}
\usage{
mig_lscv(x, beta, Omega, xsamp, dxsamp, mckern = TRUE)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{xsamp}{matrix of points at which to evaluate the integral}

\item{dxsamp}{density of points}
}
\value{
the value of the least square cross-validation criterion
}
\description{
Given a data matrix over a half-space defined by \code{beta},
compute the average using leave-one-out cross validation density minus
half the squared density.
}
\keyword{internal}
