% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promises.R
\name{as.promise.mirai}
\alias{as.promise.mirai}
\title{Make mirai Promise}
\usage{
\method{as.promise}{mirai}(x)
}
\arguments{
\item{x}{an object of class 'mirai'.}
}
\value{
A 'promise' object.
}
\description{
Creates a 'promise' from a 'mirai'.
}
\details{
This function is an S3 method for the generic \code{as.promise()} for class
'mirai'.

Requires the \pkg{promises} package.

Allows a 'mirai' to be used with the promise pipe \verb{\%...>\%}, which schedules a
function to run upon resolution of the 'mirai'.
}
\examples{
\dontshow{if (interactive() && requireNamespace("promises", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(promises)

p <- as.promise(mirai("example"))
print(p)
is.promise(p)

p2 <- mirai("completed") \%...>\% identity()
p2$then(cat)
is.promise(p2)
\dontshow{\}) # examplesIf}
}
