% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-liftover.R
\name{gintervals.load_chain}
\alias{gintervals.load_chain}
\title{Loads assembly conversion table from a chain file}
\usage{
gintervals.load_chain(
  file = NULL,
  src_overlap_policy = "error",
  tgt_overlap_policy = "auto",
  src_groot = NULL,
  min_score = NULL
)
}
\arguments{
\item{file}{name of chain file}

\item{src_overlap_policy}{policy for handling source overlaps: "error" (default), "keep", or "discard". "keep" allows one source interval to map to multiple target intervals, "discard" discards all source intervals that have overlaps and "error" throws an error if source overlaps are detected.}

\item{tgt_overlap_policy}{policy for handling target overlaps. One of:
\tabular{ll}{
  Policy \tab Description \cr
  error \tab Throws an error if any target overlaps are detected. \cr
  auto \tab Default. Alias for "auto_score". \cr
  auto_score \tab Resolves overlaps by segmenting the target region and selecting the best chain for each segment based on alignment score (highest score wins). Tie-breakers: longest span, then lowest chain_id. \cr
  auto_longer \tab Resolves overlaps by segmenting and selecting the chain with the longest span for each segment. Tie-breakers: highest score, then lowest chain_id. \cr
  auto_first \tab Resolves overlaps by segmenting and selecting the chain with the lowest chain_id for each segment. \cr
  keep \tab Preserves all overlapping intervals. \cr
  discard \tab Discards any chain interval that has a target overlap with another chain interval. \cr
  agg \tab Segments overlaps into smaller disjoint regions where each region contains all contributing chains, allowing downstream aggregation to process multiple values per region. \cr
  best_source_cluster \tab Best source cluster strategy based on source overlap. When multiple chains map a source interval, clusters them by source overlap: if chain source intervals overlap (indicating true duplications), all mappings are retained; if chain source intervals are disjoint (indicating conflicting/alternative mappings), only the cluster with the largest total target length is kept. \cr
}}

\item{src_groot}{optional path to source genome database for validating source chromosomes and coordinates. If provided, the function temporarily switches to this database to verify that all source chromosomes exist and coordinates are within bounds, then restores the original database.}

\item{min_score}{optional minimum alignment score threshold. Chains with scores below this value are filtered out. Useful for excluding low-quality alignments.}
}
\value{
A data frame representing assembly conversion table with columns: chrom, start, end, strand, chromsrc, startsrc, endsrc, strandsrc, chain_id, score.
}
\description{
Loads assembly conversion table from a chain file.
}
\details{
This function reads a file in 'chain' format and returns assembly conversion
table that can be used in 'gtrack.liftover' and 'gintervals.liftover'.

Source overlaps occur when the same source genome position maps to multiple
target genome positions. Target overlaps occur when multiple source positions
map to overlapping regions in the target genome.

The 'src_overlap_policy' controls how source overlaps are handled:
\itemize{
  \item "error" (default): Throw an error if source overlaps are detected
  \item "keep": Keep all mappings, allowing one source to map to multiple targets
  \item "discard": Remove all chain intervals involved in source overlaps
}

The 'tgt_overlap_policy' controls how target overlaps are handled:
\itemize{
  \item "error": Throw an error if target overlaps are detected
  \item "auto" (default) / "auto_first": Keep the first overlapping chain (original file order) by trimming or discarding later overlaps while keeping source/target lengths consistent
  \item "auto_longer": Keep the longer overlapping chain and trim/drop the shorter ones
  \item "discard": Remove all chain intervals involved in target overlaps
  \item "keep": Allow target overlaps to remain untouched (liftover must be able to handle them)
}
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
chainfile <- paste(.misha$GROOT, "data/test.chain", sep = "/")
# Load chain file with default policies
gintervals.load_chain(chainfile)

}
\seealso{
\code{\link{gintervals.liftover}}, \code{\link{gtrack.liftover}}
}
\keyword{~chain}
\keyword{~intervals}
\keyword{~liftover}
