% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.mean.R
\name{ci.mean}
\alias{ci.mean}
\alias{ci.median}
\title{(Bootstrap) Confidence Intervals for Arithmetic Means and Medians}
\usage{
ci.mean(data, ..., sigma = NULL, sigma2 = NULL, adjust = FALSE,
        boot = c("none", "norm", "basic", "stud", "perc", "bc", "bca"),
        R = 1000, seed = NULL, sample = TRUE,
        alternative = c("two.sided", "less", "greater"),
        conf.level = 0.95, group = NULL, split = NULL, sort.var = FALSE,
        na.omit = FALSE, digits = 2, as.na = NULL,
        plot = c("none", "ci", "boot"), point.size = 2.5, point.shape = 19,
        errorbar.width = 0.3, dodge.width = 0.5, hist = TRUE,
        binwidth = NULL, bins = NULL, hist.alpha = 0.4, fill = "gray85", density = TRUE,
        density.col = "#0072B2", density.linewidth = 0.5, density.linetype = "solid",
        point = TRUE, point.col = "#CC79A7", point.linewidth = 0.6,
        point.linetype = "solid", ci = TRUE, ci.col = "black",
        ci.linewidth = 0.6, ci.linetype = "dashed", line = FALSE, intercept = 0,
        linetype = "solid", line.col = "gray65", xlab = NULL, ylab = NULL,
        xlim = NULL, ylim = NULL, xbreaks = ggplot2::waiver(),
        ybreaks = ggplot2::waiver(), axis.title.size = 11, axis.text.size = 10,
        strip.text.size = 11, title = NULL, subtitle = NULL, group.col = NULL,
        plot.margin = NA, legend.title = "",
        legend.position = c("right", "top", "left", "bottom", "none"),
        legend.box.margin = c(-10, 0, 0, 0), facet.ncol = NULL, facet.nrow = NULL,
        facet.scales = "free", filename = NULL, width = NA, height = NA,
        units = c("in", "cm", "mm", "px"), dpi = 600, write = NULL,
        append = TRUE, check = TRUE, output = TRUE)

ci.median(data, ..., boot = c("none", "norm", "basic", "stud", "perc", "bc", "bca"),
          R = 1000, seed = NULL, sample = TRUE,
          alternative = c("two.sided", "less", "greater"),
          conf.level = 0.95, group = NULL, split = NULL, sort.var = FALSE,
          na.omit = FALSE, digits = 2, as.na = NULL, plot = c("none", "ci", "boot"),
          point.size = 2.5, point.shape = 19, errorbar.width = 0.3, dodge.width = 0.5,
          hist = TRUE, binwidth = NULL, bins = NULL, hist.alpha = 0.4, fill = "gray85",
          density = TRUE, density.col = "#0072B2", density.linewidth = 0.5,
          density.linetype = "solid", point = TRUE, point.col = "#CC79A7",
          point.linewidth = 0.6, point.linetype = "solid", ci = TRUE, ci.col = "black",
          ci.linewidth = 0.6, ci.linetype = "dashed", line = FALSE, intercept = 0,
          linetype = "solid", line.col = "gray65", xlab = NULL, ylab = NULL,
          xlim = NULL, ylim = NULL, xbreaks = ggplot2::waiver(),
          ybreaks = ggplot2::waiver(), axis.title.size = 11, axis.text.size = 10,
          strip.text.size = 11, title = NULL, subtitle = NULL, group.col = NULL,
          plot.margin = NA,  legend.title = "",
          legend.position = c("right", "top", "left", "bottom", "none"),
          legend.box.margin = c(-10, 0, 0, 0), facet.ncol = NULL, facet.nrow = NULL,
          facet.scales = "free", filename = NULL, width = NA, height = NA,
          units = c("in", "cm", "mm", "px"), dpi = 600, write = NULL, append = TRUE,
          check = TRUE, output = TRUE)
}
\arguments{
\item{data}{a numeric vector or data frame with numeric
variables, i.e., factors and character variables are
excluded from \code{data} before conducting the
analysis.}

\item{...}{an expression indicating the variable names in \code{data}
e.g., \code{ci.mean(x1, x2, data = dat)}. Note that the
operators \code{+}, \code{-}, \code{~},
\code{:}, \code{::}, and \code{!} can also be used
to select variables, see 'Details' in the
\code{\link{df.subset}} function.}

\item{sigma}{a numeric vector indicating the population standard
deviation when computing confidence intervals for the
arithmetic mean with known standard deviation Note
that either argument \code{sigma} or argument
\code{sigma2} is specified and it is only possible to
specify one value for the argument \code{sigma} even
though multiple variables are specified in \code{data}.}

\item{sigma2}{a numeric vector indicating the population variance
when computing confidence intervals for the arithmetic
mean with known variance. Note that either argument
\code{sigma} or argument \code{sigma2} is specified
and it is only possible to specify one value for the
argument \code{sigma2} even though multiple variables
are specified in \code{data}.}

\item{adjust}{logical: if \code{TRUE}, difference-adjustment for
the confidence intervals for the arithmetic mean
(Baguley, 2012) is applied.}

\item{boot}{a character string specifying the type of bootstrap
confidence intervals (CI), i.e., \code{"none"}
(default) for not conducting bootstrapping, \code{"norm"}
for the bias-corrected normal approximation bootstrap CI,
\code{"basic"} for the basic bootstrap CI, \code{"stud"}
for the studentized bootstrap CI, \code{"perc"}, for
the percentile bootstrap CI \code{"bc"} for the bias-corrected
(BC) percentile bootstrap CI (without acceleration),
and \code{"bca"} for the bias-corrected and accelerated
(BCa) bootstrap CI, see 'Details' in the
\code{\link{ci.cor}} function.}

\item{R}{a numeric value indicating the number of bootstrap
replicates (default is 1000).}

\item{seed}{a numeric value specifying seeds of the pseudo-random
numbers used in the bootstrap algorithm when conducting
bootstrapping.}

\item{sample}{logical: if \code{TRUE} (default), the univariate
sample skewness and kurtosis is computed, while the
population skewness and kurtosis is computed when
\code{sample = FALSE}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default),
\code{"greater"} or \code{"less"}.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence
level of the interval.}

\item{group}{either a character string indicating the variable name
of the grouping variable in \code{data},
or a vector representing the grouping variable.  The grouping variable
is excluded from the data frame specified
in \code{data}. Notethat a grouping variable can only be used when computing
confidence intervals with unknown population standard
deviation and population variance.}

\item{split}{either a character string indicating the variable name
of the split variable in \code{data},
or a vector representing the split variable. The split variable
is excluded from the data frame specified
in \code{data}.Note that a grouping variable can only be used when computing
confidence intervals with unknown population standard
deviation and population variance.}

\item{sort.var}{logical: if \code{TRUE}, output table is sorted by
variables when specifying \code{group}.}

\item{na.omit}{logical: if \code{TRUE}, incomplete cases are removed
before conducting the analysis (i.e., listwise deletion)
when specifying more than one outcome variable.}

\item{digits}{an integer value indicating the number of decimal
places to be used.}

\item{as.na}{a numeric vector indicating user-defined missing
values, i.e. these values are converted to \code{NA}
before conducting the analysis. Note that \code{as.na()}
function is only applied to \code{data}, but not to
\code{group} or \code{split}.}

\item{plot}{a character string indicating the type of the plot
to display, i.e., \code{"none"} (default) for not
displaying any plots, \code{"ci"} for displaying
confidence intervals for the arithmetic mean or median,
\code{"boot"} for displaying bootstrap samples with
histograms and density curves when the argument
\code{"boot"} is other than \code{"none"}.}

\item{point.size}{a numeric value indicating the \code{size} argument
in the \code{geom_point} function for controlling the
size of points when plotting confidence intervals
(\code{plot = "ci"}).}

\item{point.shape}{a numeric value between 0 and 25 or a character string
as plotting symbol indicating the \code{shape} argument
in the \code{geom_point} function for controlling the
symbols of points when plotting confidence intervals
(\code{plot = "ci"}).}

\item{errorbar.width}{a numeric value indicating the \code{width} argument
in the \code{geom_errorbar} function for controlling
the width of the whiskers in the \code{geom_errorbar}
function when plotting confidence intervals
(\code{plot = "ci"}).}

\item{dodge.width}{a numeric value indicating the \code{width} argument
controlling the width of the \code{geom} elements to
be dodged when specifying a grouping variable using
the argument \code{group} and plotting confidence
intervals (\code{plot = "ci"}).}

\item{hist}{logical: if \code{TRUE} (default), histograms are
drawn when plotting bootstrap samples
(\code{plot = "boot"}).}

\item{binwidth}{a numeric value or a function for specifying the
\code{binwidth} argument in the \code{geom_histogram}
function for controlling the width of the bins when
plotting bootstrap samples (\code{plot = "boot"}).}

\item{bins}{a numeric value for specifying the \code{bins} argument
in the \code{geom_histogram} function for controlling
the number of bins when plotting bootstrap samples
(\code{plot = "boot"}).}

\item{hist.alpha}{a numeric value between 0 and 1 for specifying the
\code{alpha} argument in the \code{geom_histogram}
function for controlling the opacity of the bars
when plotting bootstrap samples (\code{plot = "boot"}).}

\item{fill}{a character string specifying the \code{fill} argument
in the \code{geom_histogram} function controlling the
fill aesthetic when plotting bootstrap samples
(\code{plot = "boot"}). Note that this argument applied
only when no grouping variable was specified
\code{group = NULL}.}

\item{density}{logical: if \code{TRUE} (default), density curves are
drawn when plotting bootstrap samples (\code{plot = "boot"}).}

\item{density.col}{a character string specifying the \code{color} argument
in the \code{geom_density} function controlling the
color of the density curves when plotting bootstrap
samples (\code{plot = "boot"}). Note that this argument
applied only when no grouping variable was specified
\code{group = NULL}.}

\item{density.linewidth}{a numeric value specifying the \code{linewidth}
argument in the \code{geom_density} function controlling
the line width of the density curves when plotting
bootstrap samples (\code{plot = "boot"}).}

\item{density.linetype}{a numeric value or character string specifying the
\code{linetype} argument in the \code{geom_density}
function controlling the line type of the density
curves when plotting bootstrap samples
(\code{plot = "boot"}).}

\item{point}{logical: if \code{TRUE} (default), vertical lines
representing the point estimate of the arithmetic
mean or median are drawn when plotting bootstrap samples
(\code{plot = "boot"}).}

\item{point.col}{a character string specifying the \code{color} argument
in the \code{geom_vline} function for controlling the
color of the vertical line displaying the arithmetic
mean or median when plotting bootstrap samples
(\code{plot = "boot"}). Note that this argument
applied only when no grouping variable was specified
\code{group = NULL}.}

\item{point.linewidth}{a numeric value specifying the \code{linewdith}
argument in the \code{geom_vline} function for
controlling the line width of the vertical line
displaying the arithmetic mean or median when plotting
bootstrap samples (\code{plot = "boot"}).}

\item{point.linetype}{a numeric value or character string specifying the
\code{linetype} argument in the \code{geom_vline}
function controlling the line type of the vertical
line displaying the arithmetic mean or median when
plotting bootstrap samples (\code{plot = "boot"}).}

\item{ci}{logical: if \code{TRUE} (default), vertical lines
representing the bootstrap confidence intervals of
the arithmetic mean or median are drawn when
plotting bootstrap samples (\code{plot = "boot"}).}

\item{ci.col}{character string specifying the \code{color} argument
in the \code{geom_vline} function for controlling the
color of the vertical line displaying bootstrap
confidence intervals when plotting bootstrap samples
(\code{plot = "boot"}). Note that this argument applied
only when no grouping variable was specified
\code{group = NULL}.}

\item{ci.linewidth}{a numeric value specifying the \code{linewdith} argument
in the \code{geom_vline} function for controlling the
line width of the vertical line displaying bootstrap
confidence intervals when plotting bootstrap samples
(\code{plot = "boot"}).}

\item{ci.linetype}{a numeric value or character string specifying the
\code{linetype} argument in the \code{geom_vline}
function controlling the line type of the vertical
line displaying bootstrap confidence intervals when
plotting bootstrap samples (\code{plot = "boot"}).}

\item{line}{logical: if \code{TRUE}, a horizontal line
is drawn when \code{plot = "ci"} or a vertical line
is drawn when \code{plot = "boot"}}

\item{intercept}{a numeric value indicating the \code{yintercept} or
\code{xintercept} argument in the \code{geom_hline}
or \code{geom_vline} function controlling the position
of the horizontal or vertical line when \code{plot = "ci"}
and \code{line = TRUE} or when \code{plot = "boot"}
and \code{line = TRUE}. By default, the horizontal or
vertical line is drawn at 0.}

\item{linetype}{a character string indicating the \code{linetype}
argument in the \code{geom_hline} or \code{geom_vline}
function controlling the line type of the horizontal
or vertical line (default is \code{linetype = "dashed"}).}

\item{line.col}{a character string indicating the \code{color} argument
in the \code{geom_hline} or \code{geom_vline} function
for controlling the color of the horizontal or vertical
line.}

\item{xlab}{a character string indicating the \code{name} argument
in the \code{scale_x_continuous} function for labeling
the x-axis. The default setting is \code{xlab = NULL}
when \code{plot = "ci"} and \code{xlab = "Arithmetic Mean"}
or \code{xlab = "Median"} when \code{plot = "boot"}.}

\item{ylab}{a character string indicating the \code{name} argument
in the \code{scale_y_continuous} function for labeling
the y-axis. The default setting is \code{ylab = "Arithmetic Mean"}
or \code{ylab = "Median"} when \code{plot = "ci"} and
\code{ylab = "Probability Density, f(x)"} when \code{plot = "boot"}.}

\item{xlim}{a numeric vector with two elements indicating the
\code{limits} argument in the \code{scale_x_continuous}
function for controlling the scale range of the x-axis.}

\item{ylim}{a numeric vector with two elements indicating the
\code{limits} argument in the \code{scale_y_continuous}
function for controlling the scale range of the y-axis.}

\item{xbreaks}{a numeric vector indicating the \code{breaks} argument
in the \code{scale_x_continuous} function for controlling
the x-axis breaks. The default setting is
\code{xbreaks = NULL} when \code{plot = "ci"}
and \code{xbreaks = seq(-1, 1, by = 0.25)} when
\code{plot = "boot"}.}

\item{ybreaks}{a numeric vector indicating the \code{breaks} argument
in the \code{scale_y_continuous} function for controlling
the y-axis breaks. The default setting is
\code{ybreaks = seq(-1, 1, by = 0.25)} when
\code{plot = "ci"} and \code{ybreaks = NULL} when
\code{plot = "boot"}.}

\item{axis.title.size}{a numeric value indicating the \code{size} argument
in the \code{element_text} function for specifying the
function controlling the font size of the axis title,
i.e., \code{theme(axis.title = element_text(size = axis.text.size))}.}

\item{axis.text.size}{a numeric value indicating the \code{size} argument
in the \code{element_text} function for specifying the
function controlling the font size of the axis text,
i.e., \code{theme(axis.text = element_text(size = axis.text.size))}.}

\item{strip.text.size}{a numeric value indicating the \code{size} argument
in the \code{element_text} function for specifying the
function controlling the font size of the strip text,
i.e., \code{theme(strip.text = element_text(size = strip.text.size))}.}

\item{title}{a character string indicating the \code{title} argument
in the \code{labs} function for the subtitle of the plot.}

\item{subtitle}{a character string indicating the \code{subtite} argument
in the \code{labs} function for the subtitle of the plot.}

\item{group.col}{a character vector indicating the \code{color} argument
in the \code{scale_color_manual} and \code{scale_fill_manual}
functions when specifying a grouping variable using
the argument \code{group}.}

\item{plot.margin}{a numeric vector with four elements indicating the
\code{plot.margin} argument in the \code{theme} function
controlling the plot margins . The default setting
is \code{c(5.5, 5.5, 5.5, 5.5)}, but switches
to \code{c(5.5, 5.5, -2.5, 5.5)} when specifying a
grouping variable using the argument \code{group}.}

\item{legend.title}{a character string indicating the \code{color} argument
in the \code{labs} function for specifying the legend
title when specifying a grouping variable using the
argument \code{group}.}

\item{legend.position}{a character string indicating the \code{legend.position}
in the \code{theme} argument for controlling the
position of the legend  function when specifying a
grouping variable using the argument \code{group}.
By default, the legend is placed at the bottom the
plot.}

\item{legend.box.margin}{a numeric vector with four elements indicating the
\code{legend.box.margin} argument in the \code{theme}
function for controlling the margins around the full
legend area when specifying a grouping variable using
the argument \code{group}.}

\item{facet.ncol}{a numeric value indicating the \code{ncol} argument
in the \code{facet_wrap} function for controlling
the number of columns when specifying a split variable
using the argument \code{split}.}

\item{facet.nrow}{a numeric value indicating the \code{nrow} argument
in the \code{facet_wrap} function for controlling the
number of rows when specifying a split variable using
the argument \code{split}.}

\item{facet.scales}{a character string indicating the \code{scales} argument
in the \code{facet_wrap} function for controlling the
scales shared across facets, i.e., \code{"fixed"},
\code{"free_x"}, \code{"free_y"}, or \code{"free"}
(default) when specifying a split variable using
the argument \code{split}.}

\item{filename}{a character string indicating the \code{filename}
argument including the file extension in the \code{ggsave}
function. Note that one of \code{".eps"}, \code{".ps"},
\code{".tex"}, \code{".pdf"} (default),
\code{".jpeg"}, \code{".tiff"}, \code{".png"},
\code{".bmp"}, \code{".svg"} or \code{".wmf"} needs
to be specified as file extension in the \code{file}
argument. Note that plots can only be saved when
\code{plot = "ci"} or \code{plot = "boot"}.}

\item{width}{a numeric value indicating the \code{width} argument
(default is the size of the current graphics device)
in the \code{ggsave} function.}

\item{height}{a numeric value indicating the \code{height} argument
(default is the size of the current graphics device)
in the \code{ggsave} function.}

\item{units}{a character string indicating the \code{units} argument
(default is \code{in}) in the \code{ggsave} function.}

\item{dpi}{a numeric value indicating the \code{dpi} argument
(default is \code{600}) in the \code{ggsave} function.}

\item{write}{a character string naming a file for writing the output
into either a text file with file extension \code{".txt"}
(e.g., \code{"Output.txt"}) or Excel file with file
extension \code{".xlsx"}  (e.g., \code{"Output.xlsx"}).
If the file name does not contain any file extension,
an Excel file will be written.}

\item{append}{logical: if \code{TRUE} (default), output will be
appended to an existing text file with extension
\code{.txt} specified in \code{write}, if \code{FALSE}
existing text file will be overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown
on the console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{data}}{list with the input specified in \code{data}, \code{group}, and \code{split}}
\item{\code{args}}{specification of function arguments}
\item{\code{boot}}{data frame with bootstrap replicates of the arithmetic mean of median when bootstrapping was requested}
\item{\code{plot}}{ggplot2 object for plotting the results and the data frame used for plotting}
\item{\code{result}}{result table}
}
\description{
The function \code{ci.mean} computes and plots confidence intervals for
arithmetic means with known or unknown population standard deviation or
population variance and the function \code{ci.median} computes confidence
intervals for medians, optionally by a grouping and/or split variable. These
functions also supports six types of bootstrap confidence intervals (e.g.,
bias-corrected (BC) percentile bootstrap or bias-corrected and accelerated
(BCa) bootstrap confidence intervals) and plots the bootstrap samples with
histograms and density curves.
}
\note{
Bootstrap confidence intervals are computed using the R package \code{boot}
by Angelo Canty and Brain Ripley (2024).
}
\examples{
#----------------------------------------------------------------------------
# Confidence Interval (CI) for the Arithmetic Mean

# Example 1a: Two-Sided 95% CI
ci.mean(mtcars)

# Example 1b: Two-Sided 95% Difference-Adjusted CI
ci.mean(mtcars, adjust = TRUE)

# Example 1c: Two-Sided 95% CI with known population standard deviation
ci.mean(mtcars, mpg, sigma = 6)

# Alternative specification without using the '...' argument
ci.mean(mtcars$mpg, sigma = 6)

#----------------------------------------------------------------------------
# Confidence Interval (CI) for the Median

# Example 2a: Two-Sided 95% CI
ci.median(mtcars)

# Example 2b: One-Sided 99% CI
ci.median(mtcars, alternative = "less", conf.level = 0.99)

\dontrun{
#----------------------------------------------------------------------------
# Bootstrap Confidence Interval (CI)

# Example 3a: Bias-corrected (BC) percentile bootstrap CI
ci.mean(mtcars, boot = "bc")

# Example 3b: Bias-corrected and accelerated (BCa) bootstrap CI,
# 5000 bootstrap replications, set seed of the pseudo-random number generator
ci.mean(mtcars, boot = "bca", R = 5000, seed = 123)

#----------------------------------------------------------------------------
# Grouping and Split Variable

# Example 4a: Grouping variable
ci.mean(mtcars, mpg, cyl, disp, group = "vs")

# Alternative specification without using the '...' argument
ci.mean(mtcars[, c("mpg", "cyl", "disp")], group = mtcars$vs)

# Example 4b: Split variable
ci.mean(mtcars, mpg, cyl, disp, split = "am")

# Alternative specification
ci.mean(mtcars[, c("mpg", "cyl", "disp")], split = mtcars$am)

# Example 4c: Grouping and split variable
ci.mean(mtcars, mpg, cyl, disp, group = "vs", split = "am")

# Alternative specification
ci.mean(mtcars[, c("mpg", "cyl", "disp")], group = mtcars$vs, split = mtcars$am)

#----------------------------------------------------------------------------
# Write Output

# Example 5a: Text file
ci.mean(mtcars, write = "CI_Mean_Text.txt")

# Example 5b: Excel file
ci.mean(mtcars, write = "CI_Mean_Excel.xlsx")

#----------------------------------------------------------------------------
# Plot Confidence Intervals

# Example 6a: Two-Sided 95% CI
ci.mean(mtcars, disp, hp, plot = "ci")

# Example 6b: Grouping variable
ci.mean(mtcars, disp, hp, group = "vs", plot = "ci")

# Example 6c: Split variable
ci.mean(mtcars, disp, hp, split = "am", plot = "ci")

# Example 6d: Save plot as PDF file
ci.mean(mtcars, disp, hp, plot = "ci", saveplot = "CI_Mean.pdf",
        width = 9, height = 6)

# Example 6e: Save plot as PNG file
ci.mean(mtcars, disp, hp, plot = "ci", saveplot = "CI_Mean.png",
        width = 9, height = 6)

#----------------------------------------------------------------------------
# Example 7: Plot Bootstrap Samples

# Example 7a: Two-Sided 95% CI
ci.mean(mtcars, disp, hp, boot = "bc", plot = "boot")

# Example 7b: Grouping variable
ci.mean(mtcars, disp, hp, group = "vs", boot = "bc", plot = "boot")

# Example 7c: Split variable
ci.mean(mtcars, disp, hp, split = "am", boot = "bc", plot = "boot")

# Example 7d: Save plot as PDF file
ci.mean(mtcars, disp, hp, boot = "bc", plot = "boot", saveplot = "CI_Mean_Boot.pdf",
        width = 12, height = 7)

# Example 7e: Save plot as PNG file
ci.mean(mtcars, disp, hp, boot = "bc", plot = "boot", saveplot = "CI_Mean_Boot.png",
        width = 12, height = 7)
}
}
\references{
Baguley, T. S. (2012). \emph{Serious stats: A guide to advanced statistics for
the behavioral sciences}. Palgrave Macmillan.

Canty, A., & Ripley, B. (2024). \emph{boot: Bootstrap R (S-Plus) Functions}.
R package version 1.3-31.

Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology
- Using R and SPSS}. John Wiley & Sons.
}
\seealso{
\code{\link{test.z}}, \code{\link{test.t}}, \code{\link{ci.mean.diff}},
\code{\link{ci.cor}}, \code{\link{ci.prop}}, \code{\link{ci.var}},
\code{\link{ci.sd}}, \code{\link{descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
