% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_tri_dist.R
\name{conv_tri_dist}
\alias{conv_tri_dist}
\title{Convolution of the triangular distribution with the mixture component density (continuous case)}
\usage{
conv_tri_dist(x, sigma = sd(x), r = x, mu = mean(x), route, quantity = "zero")
}
\arguments{
\item{x}{vector of index case to case intervals}

\item{sigma}{standard deviation of density distribution}

\item{r}{description??}

\item{mu}{mean of density distribution}

\item{route}{integer; between 1 and 7 and indicates the route of transmission.}

\item{quantity}{character; "zero", "lower", "upper"}
}
\value{
vector of density draws for each value of x
}
\description{
We split the folded normal distribution for Primary-Secondary, Primary-Tertiary and Primary-Quaternary routes into two parts
\itemize{
\item component 1: Co-Primary route
\item component 2+3: Primary-Secondary route
\item component 4+5: Primary-Tertiary route
\item component 6+7: Primary-Quaternary route
}
}
\examples{
iccs <- 1:30
conv_tri_dist(x = iccs, route = 1)
}
