% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_helpers.R
\name{gt_mlb}
\alias{gt_mlb}
\alias{gt_fmt_mlb_logo}
\alias{gt_fmt_mlb_scoreboard_logo}
\alias{gt_fmt_mlb_dot_logo}
\title{Add MLB team logos into rows of a \code{gt} table}
\usage{
gt_fmt_mlb_logo(gt_object, columns, height = 30, locations = NULL)

gt_fmt_mlb_scoreboard_logo(gt_object, columns, height = 30, locations = NULL)

gt_fmt_mlb_dot_logo(gt_object, columns, height = 30, locations = NULL)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.
Argument has no effect if \code{locations} is not \code{NULL}.}

\item{height}{The absolute height (px) of the image in the table cell}

\item{locations}{If \code{NULL} (the default), the function will render
logos in argument \code{columns}.
Otherwise, the cell or set of cells to be associated with the team name
transformation. Only the \code{\link[gt:cells_body]{gt::cells_body()}}, \code{\link[gt:cells_stub]{gt::cells_stub()}},
\code{\link[gt:cells_column_labels]{gt::cells_column_labels()}}, and \code{\link[gt:cells_row_groups]{gt::cells_row_groups()}} helper functions
can be used here. We can enclose several of these calls within a \code{list()}
if we wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_fmt_mlb_logo}, \code{gt_fmt_mlb_scoreboard_logo}, and \code{gt_fmt_mlb_dot_logo} functions take an existing
\code{gt_tbl} object and converts MLB team names from \code{valid_team_names()} into team logos.
This is a wrapper around
\href{https://jthomasmock.github.io/gtExtras/reference/gt_img_rows.html}{\code{gtExtras::gt_image_rows()}}
written by Tom Mock, which is a wrapper around \code{gt::text_transform()} + \code{gt::web_image()}/
\code{gt::local_image()} with the necessary boilerplate already applied.
}
\examples{
library(gt)
library(mlbplotR)

df <- data.frame(team = valid_team_names()[1:5],
                 logo = valid_team_names()[1:5],
                 scoreboard_logo = valid_team_names()[1:5],
                 dot_logo = valid_team_names()[1:5])

gt_logo_example <- df \%>\%
 gt::gt() \%>\%
 gt_fmt_mlb_logo(columns = "logo") \%>\%
 gt_fmt_mlb_scoreboard_logo(columns = "scoreboard_logo") \%>\%
 gt_fmt_mlb_dot_logo(columns = "dot_logo")
}
