#' @importFrom utils bibentry
bibentries = c(
  dua_2019 = bibentry("misc",
    author = "Dua, Dheeru and Graff, Casey",
    year = "2017",
    title = "UCI Machine Learning Repository",
    url = "http://archive.ics.uci.edu/ml/",
    institution = "University of California, Irvine, School of Information and Computer Sciences"
  ),

  hardt_2016 = bibentry("inproceedings",
    author = "Moritz Hardt and Eric Price and Nathan Srebro",
    title = "Equality of Opportunity in Supervised Learning",
    url = "https://papers.nips.cc/paper/2016/file/9d2682367c3935defcb1f9e247a97c0d-Paper.pdf",
    booktitle = "Advances in Neural Information Processing Systems",
    volume = "29",
    year = "2016",
    pages = "3315--3323"
  ),

  pleiss_2017 = bibentry("inproceedings",
    author = "Pleiss, Geoff and Raghavan, Manish and Wu, Felix and Kleinberg, Jon and Weinberger, Kilian Q",
    booktitle = "Advances in Neural Information Processing Systems",
    editor = "I. Guyon and U. V. Luxburg and S. Bengio and H. Wallach and R. Fergus and S. Vishwanathan and R. Garnett",
    publisher = "Curran Associates, Inc.",
    title = "On Fairness and Calibration",
    url = "https://proceedings.neurips.cc/paper/2017/file/b8b9c74ac526fffbeb2d39ab038d1cd7-Paper.pdf",
    volume = "30",
    year = "2017"
  ),

  kamiran12 = bibentry("article",
    title="Data preprocessing techniques for classification without discrimination",
    author="Kamiran, Faisal and Calders, Toon",
    journal="Knowledge and Information Systems",
    volume="33",
    number="1",
    pages="1--33",
    year="2012",
    publisher="Springer"
  ),

  datasheets = bibentry("article",
    title="Datasheets for datasets",
    author="Gebru, Timnit and Morgenstern, Jamie and Vecchione, Briana and Vaughan, Jennifer Wortman and Wallach, Hanna and Daume III, Hal and Crawford, Kate",
    journal="arXiv preprint arXiv:1803.09010",
    year="2018"
  ),

  modelcards = bibentry("inproceedings",
    title="Model cards for model reporting",
    author="Mitchell, Margaret and Wu, Simone and Zaldivar, Andrew and Barnes, Parker and Vasserman, Lucy and Hutchinson, Ben and Spitzer, Elena and Raji, Inioluwa Deborah and Gebru, Timnit",
    booktitle="Proceedings of the conference on fairness, accountability, and transparency",
    pages="220--229",
    year="2019"
  ),

  komiyama = bibentry("inproceedings",
    title="Nonconvex Optimization for Regression with Fairness Constraints",
    author="Komiyama J, Takeda A, Honda J, Shimao H",
    booktitle="Proceedings of the 35th International Conference on Machine Learning (ICML), PMLR 80",
    pages="2737-2746",
    year="2018"
  ),

  zafar19a = bibentry("inproceedings",
    title="Fairness Constraints: a Flexible Approach for Fair Classification",
    author="Zafar BJ, Valera I, Gomez-Rodriguez M, Gummadi KP",
    booktitle="Journal of Machine Learning Research, 30",
    pages="1-42",
    year="2019"
  ),

  scutari21 = bibentry("article",
    title="Achieving Fairness with a Simple Ridge Penalty",
    author="Marco Scutari and Francesca Panero and Manuel Proissl",
    journal="arXiv preprint arXiv:2105.13817",
    year="2021"
  ),

  saleiro18 = bibentry("article",
    title="Aequitas: A bias and fairness audit toolkit",
    author="Saleiro, Pedro and Kuester, Benedict and Hinkson, Loren and London, Jesse and Stevens, Abby and Anisfeld, Ari and Rodolfa, Kit T and Ghani, Rayid",
    journal="arXiv preprint arXiv:1811.05577",
    year="2018"
  ),

  bao2021s = bibentry("inproceedings",
    title="It's COMPASlicated: The Messy Relationship between RAI Datasets and Algorithmic Fairness Benchmarks",
    author="Bao, Michelle and Zhou, Angela and Zottola, Samantha A and Brubach, Brian and Desmarais, Sarah and Horowitz, Aaron Seth and Lum, Kristian and Venkatasubramanian, Suresh",
    booktitle="Thirty-fifth Conference on Neural Information Processing Systems Datasets and Benchmarks Track (Round 1)",
    year="2021"
  ),

  ding2021retiring = bibentry("inproceedings",
    title="Retiring adult: New datasets for fair machine learning",
    author="Ding, Frances and Hardt, Moritz and Miller, John and Schmidt, Ludwig",
    booktitle="Thirty-fifth Conference on Neural Information Processing Systems Datasets and Benchmarks Track (Round 1)",
    year="2021"
  )

)
