% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputTrafo.R
\name{InputTrafo}
\alias{InputTrafo}
\title{Input Transformation Base Class}
\description{
Abstract input transformation class.

An input transformation can be used within a \link{Surrogate} to perform a transformation of the feature variables.
}
\seealso{
Other Input Transformation: 
\code{\link{InputTrafoUnitcube}},
\code{\link{mlr_input_trafos}}
}
\concept{Input Transformation}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{label}}{(\code{character(1)})\cr
Label for this object.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.}

\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}

\item{\code{state}}{(named \code{list()} | \code{NULL})\cr
List of meta information regarding the parameters and their state.}

\item{\code{search_space}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Search space.}

\item{\code{cols_x}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Column ids of feature variables that should be transformed.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-InputTrafo-new}{\code{InputTrafo$new()}}
\item \href{#method-InputTrafo-update}{\code{InputTrafo$update()}}
\item \href{#method-InputTrafo-transform}{\code{InputTrafo$transform()}}
\item \href{#method-InputTrafo-format}{\code{InputTrafo$format()}}
\item \href{#method-InputTrafo-print}{\code{InputTrafo$print()}}
\item \href{#method-InputTrafo-clone}{\code{InputTrafo$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-new"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$new(label = NA_character_, man = NA_character_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{(\code{character(1)})\cr
Label for this object.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-update"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-update}{}}}
\subsection{Method \code{update()}}{
Learn the transformation based on observed data and update parameters in \verb{$state}.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$update(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_x}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-transform"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-transform}{}}}
\subsection{Method \code{transform()}}{
Perform the transformation.
Must be implemented by subclasses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$transform(xdt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xdt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_x}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the transformation applied to the columns \verb{$cols_x} (if applicable) or a subset thereof.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-format"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$format()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character(1)}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-print"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-InputTrafo-clone"></a>}}
\if{latex}{\out{\hypertarget{method-InputTrafo-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{InputTrafo$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
