% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackSetTB.R
\name{mlr_callback_set.tb}
\alias{mlr_callback_set.tb}
\alias{CallbackSetTB}
\title{TensorBoard Logging Callback}
\description{
Logs training loss, training measures, and validation measures as events.
To view them, use TensorBoard with \code{tensorflow::tensorboard()} (requires \code{tensorflow}) or the CLI.
}
\details{
Logs events at most every epoch.
}
\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_callback_set.unfreeze}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}
}
\concept{Callback}
\section{Super class}{
\code{\link[mlr3torch:CallbackSet]{mlr3torch::CallbackSet}} -> \code{CallbackSetTB}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackSetTB-new}{\code{CallbackSetTB$new()}}
\item \href{#method-CallbackSetTB-on_epoch_end}{\code{CallbackSetTB$on_epoch_end()}}
\item \href{#method-CallbackSetTB-clone}{\code{CallbackSetTB$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="load_state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-load_state_dict'><code>mlr3torch::CallbackSet$load_state_dict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="print"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-print'><code>mlr3torch::CallbackSet$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3torch" data-topic="CallbackSet" data-id="state_dict"><a href='../../mlr3torch/html/CallbackSet.html#method-CallbackSet-state_dict'><code>mlr3torch::CallbackSet$state_dict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetTB-new"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetTB-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetTB$new(path, log_train_loss)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(\code{character(1)})\cr
The path to a folder where the events are logged.
Point TensorBoard to this folder to view them.}

\item{\code{log_train_loss}}{(\code{logical(1)})\cr
Whether we log the training loss.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetTB-on_epoch_end"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetTB-on_epoch_end}{}}}
\subsection{Method \code{on_epoch_end()}}{
Logs the training loss, training measures, and validation measures as TensorBoard events.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetTB$on_epoch_end()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSetTB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSetTB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSetTB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
