% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerBatchRandomSearch.R
\name{mlr_tuners_random_search}
\alias{mlr_tuners_random_search}
\alias{TunerBatchRandomSearch}
\title{Hyperparameter Tuning with Random Search}
\source{
Bergstra J, Bengio Y (2012).
\dQuote{Random Search for Hyper-Parameter Optimization.}
\emph{Journal of Machine Learning Research}, \bold{13}(10), 281--305.
\url{https://jmlr.csail.mit.edu/papers/v13/bergstra12a.html}.
}
\description{
Subclass for random search tuning.
}
\details{
The random points are sampled by \code{\link[paradox:generate_design_random]{paradox::generate_design_random()}}.
}
\section{Dictionary}{

This \link{Tuner} can be instantiated with the associated sugar function \code{\link[=tnr]{tnr()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tnr("random_search")
}\if{html}{\out{</div>}}
}

\section{Parallelization}{

In order to support general termination criteria and parallelization, we
evaluate points in a batch-fashion of size \code{batch_size}. Larger batches mean
we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria. A batch contains of \code{batch_size} times \code{resampling$iters} jobs.
E.g., if you set a batch size of 10 points and do a 5-fold cross validation, you can
utilize up to 50 cores.

Parallelization is supported via package \CRANpkg{future} (see \code{\link[mlr3:benchmark]{mlr3::benchmark()}}'s
section on parallelization for more details).
}

\section{Logging}{

All \link{Tuner}s use a logger (as implemented in \CRANpkg{lgr}) from package
\CRANpkg{bbotk}.
Use \code{lgr::get_logger("bbotk")} to access and control the logger.
}

\section{Optimizer}{

This \link{Tuner} is based on \link[bbotk:mlr_optimizers_random_search]{bbotk::OptimizerBatchRandomSearch} which can be applied on any black box optimization problem.
See also the documentation of \href{https://bbotk.mlr-org.com/}{bbotk}.
}

\section{Parameters}{


\describe{
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of points to try in a batch.}
}

}

\section{Resources}{

There are several sections about hyperparameter optimization in the \href{https://mlr3book.mlr-org.com}{mlr3book}.
\itemize{
\item Getting started with \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html}{hyperparameter optimization}.
\item An overview of all tuners can be found on our \href{https://mlr-org.com/tuners.html}{website}.
\item \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-model-tuning}{Tune} a support vector machine on the Sonar data set.
\item Learn about \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-defining-search-spaces}{tuning spaces}.
\item Estimate the model performance with \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-nested-resampling}{nested resampling}.
\item Learn about \href{https://mlr3book.mlr-org.com/chapters/chapter5/advanced_tuning_methods_and_black_box_optimization.html#sec-multi-metrics-tuning}{multi-objective optimization}.
\item Simultaneously optimize hyperparameters and use \href{https://mlr3book.mlr-org.com/chapters/chapter15/predsets_valid_inttune.html}{early stopping} with XGBoost.
\item \href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html#sec-autotuner}{Automate} the tuning.
}

The \href{https://mlr-org.com/gallery-all-optimization.html}{gallery} features a collection of case studies and demos about optimization.
\itemize{
\item Learn more advanced methods with the \href{https://mlr-org.com/gallery/series/2021-03-09-practical-tuning-series-tune-a-support-vector-machine/}{Practical Tuning Series}.
\item Learn about \href{https://mlr-org.com/gallery/optimization/2023-01-16-hotstart/}{hotstarting} models.
\item Run the \href{https://mlr-org.com/gallery/optimization/2023-01-31-default-configuration/}{default hyperparameter configuration} of learners as a baseline.
\item Use the \href{https://mlr-org.com/gallery/series/2023-01-15-hyperband-xgboost/}{Hyperband} optimizer with different budget parameters.
}

The \href{https://cheatsheets.mlr-org.com/mlr3tuning.pdf}{cheatsheet} summarizes the most important functions of mlr3tuning.
}

\section{Progress Bars}{


\verb{$optimize()} supports progress bars via the package \href{https://CRAN.R-project.org/package=progressr}{\pkg{progressr}}
combined with a \link[bbotk]{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\href{https://CRAN.R-project.org/package=progress}{\pkg{progress}} as backend; enable with \code{progressr::handlers("progress")}.

}

\examples{
# Hyperparameter Optimization

# load learner and set search space
learner = lrn("classif.rpart",
  cp = to_tune(1e-04, 1e-1, logscale = TRUE)
)

# run hyperparameter tuning on the Palmer Penguins data set
instance = tune(
  tuner = tnr("random_search"),
  task = tsk("penguins"),
  learner = learner,
  resampling = rsmp("holdout"),
  measure = msr("classif.ce"),
  term_evals = 10
)

# best performing hyperparameter configuration
instance$result

# all evaluated hyperparameter configuration
as.data.table(instance$archive)

# fit final model on complete data set
learner$param_set$values = instance$result_learner_param_vals
learner$train(tsk("penguins"))
}
\seealso{
Package \CRANpkg{mlr3hyperband} for hyperband tuning.

Other Tuner: 
\code{\link{Tuner}},
\code{\link{mlr_tuners}},
\code{\link{mlr_tuners_cmaes}},
\code{\link{mlr_tuners_design_points}},
\code{\link{mlr_tuners_gensa}},
\code{\link{mlr_tuners_grid_search}},
\code{\link{mlr_tuners_internal}},
\code{\link{mlr_tuners_irace}},
\code{\link{mlr_tuners_nloptr}}
}
\concept{Tuner}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerBatch]{mlr3tuning::TunerBatch}} -> \code{\link[mlr3tuning:TunerBatchFromOptimizerBatch]{mlr3tuning::TunerBatchFromOptimizerBatch}} -> \code{TunerBatchRandomSearch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerBatchRandomSearch-new}{\code{TunerBatchRandomSearch$new()}}
\item \href{#method-TunerBatchRandomSearch-clone}{\code{TunerBatchRandomSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="TunerBatchFromOptimizerBatch" data-id="optimize"><a href='../../mlr3tuning/html/TunerBatchFromOptimizerBatch.html#method-TunerBatchFromOptimizerBatch-optimize'><code>mlr3tuning::TunerBatchFromOptimizerBatch$optimize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchRandomSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchRandomSearch-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchRandomSearch$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerBatchRandomSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerBatchRandomSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerBatchRandomSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
