% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-methods.R
\name{mmrm_tmb_methods}
\alias{mmrm_tmb_methods}
\alias{coef.mmrm_tmb}
\alias{fitted.mmrm_tmb}
\alias{predict.mmrm_tmb}
\alias{model.frame.mmrm_tmb}
\alias{model.matrix.mmrm_tmb}
\alias{terms.mmrm_tmb}
\alias{logLik.mmrm_tmb}
\alias{formula.mmrm_tmb}
\alias{vcov.mmrm_tmb}
\alias{VarCorr.mmrm_tmb}
\alias{VarCorr}
\alias{deviance.mmrm_tmb}
\alias{AIC.mmrm_tmb}
\alias{BIC.mmrm_tmb}
\alias{print.mmrm_tmb}
\alias{residuals.mmrm_tmb}
\alias{simulate.mmrm_tmb}
\title{Methods for \code{mmrm_tmb} Objects}
\usage{
\method{coef}{mmrm_tmb}(object, complete = TRUE, ...)

\method{fitted}{mmrm_tmb}(object, ...)

\method{predict}{mmrm_tmb}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  nsim = 1000L,
  conditional = FALSE,
  ...
)

\method{model.frame}{mmrm_tmb}(
  formula,
  data,
  include = c("subject_var", "visit_var", "group_var", "response_var"),
  exclude = NULL,
  full,
  na.action = "na.omit",
  ...
)

\method{model.matrix}{mmrm_tmb}(
  object,
  data,
  use_response = TRUE,
  contrasts.arg = attr(object$tmb_data$x_matrix, "contrasts"),
  ...
)

\method{terms}{mmrm_tmb}(x, include = "response_var", ...)

\method{logLik}{mmrm_tmb}(object, ...)

\method{formula}{mmrm_tmb}(x, ...)

\method{vcov}{mmrm_tmb}(object, complete = TRUE, ...)

\method{VarCorr}{mmrm_tmb}(x, sigma = NA, ...)

\method{deviance}{mmrm_tmb}(object, ...)

\method{AIC}{mmrm_tmb}(object, corrected = FALSE, ..., k = 2)

\method{BIC}{mmrm_tmb}(object, ...)

\method{print}{mmrm_tmb}(x, ...)

\method{residuals}{mmrm_tmb}(object, type = c("response", "pearson", "normalized"), ...)

\method{simulate}{mmrm_tmb}(
  object,
  nsim = 1,
  seed = NULL,
  newdata,
  ...,
  method = c("conditional", "marginal")
)
}
\arguments{
\item{object}{(\code{mmrm_tmb})\cr the fitted MMRM object.}

\item{complete}{(\code{flag})\cr whether to include potential non-estimable
coefficients.}

\item{...}{mostly not used;
Exception is \code{model.matrix()} passing \code{...} to the default method.}

\item{newdata}{(\code{data.frame})\cr optional new data, otherwise data from \code{object} is used.}

\item{se.fit}{(\code{flag})\cr indicator if standard errors are required.}

\item{interval}{(\code{string})\cr type of interval calculation. Can be abbreviated.}

\item{level}{(\code{number})\cr tolerance/confidence level.}

\item{nsim}{(\code{count})\cr number of simulations to use.}

\item{conditional}{(\code{flag})\cr indicator if the prediction is conditional on the observation or not.}

\item{formula}{(\code{mmrm_tmb})\cr same as \code{object}.}

\item{data}{(\code{data.frame})\cr object in which to construct the frame.}

\item{include}{(\code{character})\cr names of variable types to include in the model frame creation.
Must be \code{NULL} or one or more of \code{c("subject_var", "visit_var", "group_var", "response_var")}.}

\item{exclude}{(\code{character})\cr names of variable types to exclude after the model frame creation.
Same choices as for \code{include}.}

\item{full}{(\code{flag})\cr indicator whether to return full model frame (deprecated).}

\item{na.action}{(\code{string})\cr na action.}

\item{use_response}{(\code{flag})\cr whether to use the response for complete rows.}

\item{contrasts.arg}{(\code{list})\cr contrasts to be used.}

\item{x}{(\code{mmrm_tmb})\cr same as \code{object}.}

\item{sigma}{cannot be used (this parameter does not exist in MMRM).}

\item{corrected}{(\code{flag})\cr whether corrected AIC should be calculated.}

\item{k}{(\code{number})\cr the penalty per parameter to be used; default \code{k = 2}
is the classical AIC.}

\item{type}{(\code{string})\cr unscaled (\code{response}), \code{pearson} or \code{normalized}. Default is \code{response},
and this is the only type available for use with models with a spatial covariance structure.}

\item{seed}{unused argument from \code{\link[stats:simulate]{stats::simulate()}}.}

\item{method}{(\code{string})\cr simulation method to use. If "conditional",
simulated values are sampled given the estimated covariance matrix of \code{object}.
If "marginal", the variance of the estimated covariance matrix is taken into account.}
}
\value{
Depends on the method, see Functions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
\code{include} argument controls the variables the model frame will include upon creation.
Possible options are "response_var", "subject_var", "visit_var" and "group_var", representing the
response variable, subject variable, visit variable or group variable.
By default all four variable types are included, which means that the original model frame will be used.
If only a subset of variable types is requested, the model frame will be constructed freshly, and
if there are more complete rows (without \code{NA}s) in the required variables than in the original model frame,
those rows will be included as well.

The \code{exclude} argument can be used to exclude specific variable types after the model frame creation.
By default no variable types are excluded. The \code{exclude} argument is useful when the original
model frame should be used as basis (with same incomplete rows omitted), but some variable types should be removed
afterwards.

\code{character} values in new data will always be factorized according to the data in the fit
to avoid mismatched in levels or issues in \code{model.matrix}.
}
\section{Functions}{
\itemize{
\item \code{coef(mmrm_tmb)}: obtains the estimated coefficients.

\item \code{fitted(mmrm_tmb)}: obtains the fitted values.

\item \code{predict(mmrm_tmb)}: predict conditional means for new data;
optionally with standard errors and confidence or prediction intervals.
Returns a vector of predictions if \code{se.fit == FALSE} and
\code{interval == "none"}; otherwise it returns a data.frame with multiple
columns and one row per input data row.

\item \code{model.frame(mmrm_tmb)}: obtains the model frame.

\item \code{model.matrix(mmrm_tmb)}: obtains the model matrix.

\item \code{terms(mmrm_tmb)}: obtains the terms object.

\item \code{logLik(mmrm_tmb)}: obtains the attained log likelihood value.
Includes as attributes the number of variance parameters \code{n_param}, number
of estimated coefficients \code{n_coef}, degrees of freedom \code{df}, and number of
subjects \code{nobs}. The \code{nobs} attribute is so named so that if this
function's results are passed to \code{stats::BIC()}, the BIC value will be
calculated correctly. Resulting value is of class
\code{\link[stats:logLik]{logLik}}.

\item \code{formula(mmrm_tmb)}: obtains the used formula.

\item \code{vcov(mmrm_tmb)}: obtains the variance-covariance matrix estimate
for the coefficients.

\item \code{VarCorr(mmrm_tmb)}: obtains the variance-covariance matrix estimate
for the residuals.

\item \code{deviance(mmrm_tmb)}: obtains the deviance, which is defined here
as twice the negative log likelihood, which can either be integrated
over the coefficients for REML fits or the usual one for ML fits.

\item \code{AIC(mmrm_tmb)}: obtains the Akaike Information Criterion,
where the degrees of freedom are the number of variance parameters (\code{n_theta}).
If \code{corrected}, then this is multiplied with \code{m / (m - n_theta - 1)} where
\code{m} is the number of observations minus the number of coefficients, or
\code{n_theta + 2} if it is smaller than that \insertCite{hurvich1989regression,burnham1998practical}{mmrm}.

\item \code{BIC(mmrm_tmb)}: obtains the Bayesian Information Criterion,
which is using the natural logarithm of the number of subjects for the
penalty parameter \code{k}.

\item \code{print(mmrm_tmb)}: prints the object.

\item \code{residuals(mmrm_tmb)}: to obtain residuals - either unscaled ('response'), 'pearson' or 'normalized'.

\item \code{simulate(mmrm_tmb)}: simulate responses from a fitted model according
to the simulation \code{method}, returning a \code{data.frame} of dimension \verb{[n, m]}
where n is the number of rows in \code{newdata},
and m is the number \code{nsim} of simulated responses.

}}
\note{
If the response in the formula is a complicated expression, e.g. with multiple
variables, and not all variables are provided in \code{newdata}, a warning is issued.
In this case it is recommended to provide all variables in the \code{newdata} data set,
and manually set the response variables to \code{NA} as needed for obtaining unconditional
predictions e.g.
}
\examples{
formula <- FEV1 ~ RACE + SEX + ARMCD * AVISIT + us(AVISIT | USUBJID)
object <- fit_mmrm(formula, fev_data, weights = rep(1, nrow(fev_data)))
# Estimated coefficients:
coef(object)
# Fitted values:
fitted(object)
predict(object, newdata = fev_data)
# Model frame:
model.frame(object)
model.frame(object, include = "subject_var")
# Model matrix:
model.matrix(object)
# terms:
terms(object)
terms(object, include = "subject_var")
# Log likelihood given the estimated parameters:
logLik(object)
# Formula which was used:
formula(object)
# Variance-covariance matrix estimate for coefficients:
vcov(object)
# Variance-covariance matrix estimate for residuals:
VarCorr(object)
# REML criterion (twice the negative log likelihood):
deviance(object)
# AIC:
AIC(object)
AIC(object, corrected = TRUE)
# BIC:
BIC(object)
# residuals:
residuals(object, type = "response")
residuals(object, type = "pearson")
residuals(object, type = "normalized")
}
\references{
\itemize{
\item \insertRef{hurvich1989regression}{mmrm}
\item \insertRef{burnham1998practical}{mmrm}
}

\itemize{
\item \insertRef{galecki2013linear}{mmrm}
}
}
\seealso{
\code{\link{mmrm_methods}}, \code{\link{mmrm_tidiers}} for additional methods.
}
