% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halley_band.R
\name{halley.band}
\alias{halley.band}
\title{Halley band of the mortality profile of a skeletal population}
\usage{
halley.band(x, n = 1000, uncert = 0.95, agebeg, ageend, agerange = "excluded")
}
\arguments{
\item{x}{a data.frame with individuals and age estimations.}

\item{n}{number of runs, default: 1000.}

\item{uncert}{level of uncertainty, default: 0.95.}

\item{agebeg}{numeric. Starting age of the respective individual.}

\item{ageend}{numeric. Closing age of the respective individual.}

\item{agerange}{character. Determination if the closing
age leaves a gap to the following age category. If yes (= "excluded"),
"1" is added to avoid gaps, default: "excluded".}
}
\value{
One data.frame with the following items:

\itemize{
  \item \bold{age}:  age in years.
  \item \bold{lower_dx}: Lower boundary of uncertainty for dx.
  \item \bold{upper_dx}: Upper boundary of uncertainty for dx.
  \item \bold{lower_qx}: Lower boundary of uncertainty for qx.
  \item \bold{upper_qx}: Upper boundary of uncertainty for qx.
  \item \bold{lower_lx}: Lower boundary of uncertainty for lx.
  \item \bold{upper_lx}: Upper boundary of uncertainty for lx.
 }
}
\description{
In a series of papers, M. A. Luy and U. Wittwer-Backofen \emph{(2005; 2008)}
proposed a method they called 'Halley band' as alternative for other
methods of sampling from an skeletal population. It basically involves
sampling n times from the age-estimation of each individual and then
only taking the 2.5th and 97.5th percentile into account. The space
between, they dubbed 'Halley band' but pointed out that it
is not to be confused with confidence intervals.
}
\examples{

# create simulated population with artifical coarsening first
pop_sim <- pop.sim.gomp(n = 1000)
sim_ranges <- random.cat()

# apply random age categories to simulated ages
sim_appl <- random.cat.apply(pop_sim$result, age = "age",
age_ranges = sim_ranges, from = "from", to = "to")

# create halley bands
demo <- halley.band(sim_appl, n = 1000, uncert = 0.95, agebeg = "from",
ageend = "to", agerange = "excluded")

# plot band with ggplot
library(ggplot2)
ggplot(demo) + geom_ribbon(aes(x = age, ymin = lower_dx, ymax = upper_dx),
linetype = 0, fill = "grey")
ggplot(demo) + geom_ribbon(aes(x = age, ymin = lower_lx, ymax = upper_lx),
linetype = 0, fill = "grey")
ggplot(demo) + geom_ribbon(aes(x = age, ymin = lower_qx, ymax = upper_qx),
linetype = 0, fill = "grey")
}
\references{
\insertRef{Luy_Wittwer-Backofen_2005}{mortAAR}

\insertRef{Luy_Wittwer-Backofen_2008}{mortAAR}
}
