% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{create_or_replace_share}
\alias{create_or_replace_share}
\title{Create or replace a MotherDuck database share}
\usage{
create_or_replace_share(
  .con,
  share_name,
  database_name,
  access = "PUBLIC",
  visibility = "LISTED",
  update = "AUTOMATIC"
)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{share_name}{Character. The name of the share to create or replace.}

\item{database_name}{Character. The name of the database to be shared.}

\item{access}{Character. Access level for the share; either \code{"RESTRICTED"} or \code{"PUBLIC"} (default: \code{"PUBLIC"}).}

\item{visibility}{Character. Visibility of the share; either \code{"HIDDEN"} or \code{"LISTED"} (default: \code{"LISTED"}).}

\item{update}{Character. Update policy for the share; either \code{"AUTOMATIC"} or \code{"MANUAL"} (default: \code{"AUTOMATIC"}).}
}
\value{
A message indicating that the share has been created or replaced.
}
\description{
Creates a new share or replaces an existing share for a specified database
in MotherDuck. This allows you to update the configuration of an existing
share or create a new one if it does not exist.
}
\details{
This function executes a \verb{CREATE OR REPLACE SHARE} SQL statement to create
a new share or update an existing one.
\itemize{
\item \code{access} controls who can access the share.
\item \code{visibility} controls whether the share is listed publicly or hidden.
\item \code{update} controls whether changes to the source database are automatically reflected in the share.
The current user is displayed for confirmation before execution.
}
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(dbdir = tempfile()))
create_or_replace_share(
  .con = con,
  share_name = "analytics_share",
  database_name = "sales_db",
  access = "PUBLIC",
  visibility = "LISTED",
  update = "AUTOMATIC"
)
}

}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_schema}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
