% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_meta.R
\encoding{UTF-8}
\name{run_meta_resamples}
\alias{run_meta_resamples}
\title{Running hierarchical models (with resampling)}
\usage{
run_meta_resamples(
  rv,
  set_target = c("hr", "ctsd"),
  subpop = FALSE,
  random = FALSE,
  max_draws = 100,
  iter_step = 2,
  trace = FALSE,
  ...
)
}
\arguments{
\item{rv}{A named list containing simulation inputs, settings, and
group assignments. Must not be NULL.}

\item{set_target}{Character vector specifying the target metrics.
Options are "hr" (for home range area) and/or "ctsd" (for movement
speed). Defaults to c("hr", "ctsd").}

\item{subpop}{Logical; if TRUE, analyzes population-level inferences
by subpopulations/groups (e.g., males vs. females). Requires group
assigments in \code{rv}.}

\item{random}{Logical; if TRUE, performs random sampling of individuals
using different combinations (up to max_draws).}

\item{max_draws}{Integer; maximum number of random draws per
combination size when \code{random=TRUE}.
Ignored if \code{random=FALSE}.}

\item{iter_step}{Integer. Step size used to increment the number of
individuals sampled in each iteration. For example, if
\code{iter_step = 2}, the function will evaluate sample sizes of 2, 4,
6, etc., up to the maximum population sample size. Defaults to 2.}

\item{trace}{Logical; if TRUE, prints progress messages.
Default is FALSE.}

\item{...}{Additional arguments for advanced control:
\describe{
\item{.only_max_m}{Logical. If \code{TRUE}, runs the meta-analysis
only at the maximum population sample size. Skips all
intermediate sample sizes.}
\item{.max_m}{Integer. Sets a user-defined maximum sample size
to use in the resampling sequence. Overrides the default,
which uses all available individuals.}
\item{.m}{Integer. Specifies exact sample size to use. Overrides
automatic sequence generation. Accepts a single value.}
\item{.automate_seq}{Logical. If \code{TRUE}, automatically generates
an informative and non-redundant sequence of sample sizes
for better plot readability and runtime efficiency.}
\item{.lists}{List (Optional). Supplies precomputed input
objects, generated via \code{.build_meta_objects()}.}
}}
}
\value{
A data frame summarizing all outputs for each target,
population sample size, sample, and group (if specified). Columns
include:
\describe{
\item{type}{Research target, e.g., "hr" or "ctsd".}
\item{m}{Number of individuals in the sample.}
\item{sample}{Sample index (for repeated draws).}
\item{truth}{True value.}
\item{est}{Point estimate.}
\item{lci}{Lower confidence interval.}
\item{uci}{Upper confidence interval.}
\item{error}{Relative error.}
\item{error_lci}{Lower CI for relative error.}
\item{error_uci}{Upper CI for relative error.}
\item{ratio_truth}{True group ratio (A/B), if subpop=TRUE.}
\item{ratio_est}{Estimated group ratio.}
\item{ratio_lci}{Lower CI for estimated group ratio.}
\item{ratio_uci}{Upper CI for estimated group ratio.}
\item{overlaps}{Logical; whether estimate overlaps with the truth.}
\item{is_grouped}{Logical; TRUE if grouped.}
\item{group}{Group label ("All", "A", "B").}
\item{subpop_detected}{Logical; was a subpopulation detected?}
}
}
\description{
This function performs meta-analyses on simulated animal tracking data,
to estimate key movement metrics, such as mean home range area and/or
mean movement speed for a sampled population. The function can also
compare these metrics between two groups if specified.

When resampling is enabled, the function repeatedly draws random
subsets of individuals from the available population to simulate how
parameter estimates behave across varying population sample sizes.
This resampling allows users to assess estimate variability as sample
size increases or as individuals are resampled. For example, it can
reveal if the mean home range area converges as more individuals are
added to the sampled population.

This approach helps quantify the robustness and precision of estimated
parameters under different sampling scenarios.

The function leverages core methods from the \code{ctmm} package:
\itemize{
\item \code{ctmm::akde()}: Computes home range areas using the Autocorrelated
Kernel Density Estimator (AKDE), which explicitly accounts for the
autocorrelation in animal movement data to produce statistically
robust space-use estimates.
\item \code{ctmm::speed()}: Computes Continuous-Time Speed and Distance (CTSD)
estimates, providing biologically meaningful summaries of movement
speed, which is proportional to distance traveled.
These methods allow for robust comparisons across individuals,
groups, and resampling scenarios.
}
}
\examples{
if(interactive()) {
   run_meta_resamples(rv, set_target = "hr")
}

}
\seealso{
\code{\link[ctmm]{akde}}, \code{\link[ctmm]{speed}},
}
\author{
Inês Silva \email{i.simoes-silva@hzdr.de}
}
\keyword{internal}
