% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpspline.R
\name{mpspline}
\alias{mpspline}
\title{Spline discrete soils data - multiple sites}
\usage{
mpspline(
  obj = NULL,
  var_name = NULL,
  lam = 0.1,
  d = c(0, 5, 15, 30, 60, 100, 200),
  vlow = 0,
  vhigh = 1000
)
}
\arguments{
\item{obj}{data.frame or matrix. Column 1 must contain site
identifiers. Columns 2 and 3 must contain upper and lower sample depths,
respectively. Subsequent columns will contain measured values for those
depths.}

\item{var_name}{character or integer vector denoting the column(s) in
\code{obj} in which target data is stored. If not supplied, the fourth
column of the input object is assumed to contain the target data.}

\item{lam}{number; smoothing parameter for spline. Defaults to 0.1.}

\item{d}{sequential integer vector; denotes the output depth ranges in cm.
Defaults to \code{c(0, 5, 15, 30, 60, 100, 200)} after the GlobalSoilMap
specification, giving output predictions over intervals 0-5cm, 5-15cm,
etc.}

\item{vlow}{numeric; constrains the minimum predicted value to a realistic
number. Defaults to 0.}

\item{vhigh}{numeric; constrains the maximum predicted value to a realistic
number. Defaults to 1000.}
}
\value{
A nested list of data for each input site. List elements are: Site
  ID, vector of predicted values over input intervals, vector of predicted
  values for each cm down the profile to \code{max(d)}, vector of predicted
  values over \code{d} (output) intervals, and root mean squared error.
}
\description{
This function implements the mass-preserving spline method of Bishop \emph{et
al} (1999) (\doi{10.1016/S0016-7061(99)00003-8}) for interpolating between
measured soil attributes down a soil profile, across multiple sites' worth of
data.
}
\examples{
# single variable
dat <- data.frame("SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                   "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                   "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                  "VAL" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                   stringsAsFactors = FALSE)
m1 <- mpspline(obj = dat, var_name = 'VAL')

# multiple variables
dat_multi <- data.frame( "SID" = c( 1,  1,  1,  1,   2,   2,   2,   2),
                          "UD" = c( 0, 20, 40, 60,   0,  15,  45,  80),
                          "LD" = c(10, 30, 50, 70,   5,  30,  60, 100),
                        "VAL1" = c( 6,  4,  3, 10, 0.1, 0.9, 2.5,   6),
                        "VAL2" = c( 5,  3,  2,  9, 0.2, 1.0, 2.0,   5),
                        stringsAsFactors = FALSE)
m_multi <- mpspline(obj = dat_multi, var_name = c('VAL1', 'VAL2'))
# access results: m_multi[['VAL1']][['1']]
}
