% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrIMLperformance.R
\name{mrIMLperformance}
\alias{mrIMLperformance}
\title{Calculate general performance metrics of a mrIML model}
\usage{
mrIMLperformance(mrIMLobj)
}
\arguments{
\item{mrIMLobj}{A list object created by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}} containing
multi-response models.}
}
\value{
A list with two slots:
\itemize{
\item \verb{$model_performance}: A \pkg{tibble} of commonly used metrics that can be used
to compare model performance of classification models. Performance metrics
are based on the test data defined during \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.
\item \verb{$global_performance_summary}: A global performance metric: the average of
a performance metric over all response models. MCC is used for classification
models and RMSE for regression models.
}
}
\description{
Summarizes the performance of a \code{mrIML} object created using
\code{\link[=mrIMLpredicts]{mrIMLpredicts()}} in a way that allows for easy comparison of different models.
For regression models, root mean squared error (RMSE) and R-squared are
reported, while for classification models, area under the ROC curve (AUC),
Matthews correlation coefficient (MCC), positive predictive value (PPV),
specificity, and sensitivity are reported.
}
\examples{
mrIML_rf <- mrIML::mrIML_bird_parasites_RF

perf <- mrIMLperformance(mrIML_rf )
perf[[1]]
perf[[2]]

}
