#' Network meta-analysis for major depressive disorder
#' 
#' @description
#' Network meta-analysis comparing antidepressants in patients with major
#' depressive disorder.
#' 
#' @name antidepressants
#' 
#' @docType data
#' 
#' @format A data frame with the following columns:
#' \tabular{rl}{
#' \bold{\emph{studyid}}\tab study id \cr
#' \bold{\emph{drug_name}}\tab antidepressant name \cr
#' \bold{\emph{ntotal}}\tab number of randomized patients in treatment arm \cr
#' \bold{\emph{responders}}\tab number of responders
#' }
#' 
#' @seealso \code{\link{mtrank}}, \code{\link{tcc}}
#' 
#' @source
#' Cipriani A, Furukawa T, Salanti G, Chaimani A, et al. (2018):
#' Comparative efficacy and acceptability of 21 antidepressant drugs 
#' for the acute treatment of adults with major depressive 
#' disorder: a systematic review and network meta-analysis
#' \emph{Lancet},
#' \bold{391}, 1357--66 
#' 
#' @keywords datasets
#' 
#' @examples
#' data(antidepressants)
#' head(antidepressants)
#' #
#' # Examples:
#' # example(tcc)
#' # example(mtrank)
#' # example(fitted.mtrank)

NULL
