% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{contrast_samples}
\alias{contrast_samples}
\title{Difference between Samples at Contrasting Profiles}
\usage{
contrast_samples(model, profile1, profile2, ...)
}
\arguments{
\item{model}{An object of class multimedia containing the estimated mediation
and outcome models whose mediation and outcome predictions we want to
compare.}

\item{profile1}{An object of class \code{treatment_profile} containing the first
treatment profile to consider in the difference.}

\item{profile2}{An object of class \code{treatment_profile} containing the second
treatment profile to consider in the difference.}

\item{...}{Additional arguments to pass to \code{sample()}.}
}
\value{
A list with two elements, \code{mediators} and \code{outcomes}, containing the
differences in the sampled M(T') - M(T) and Y(T', M(T')) - Y(T, M(T))
between the two profiles T and T'.

A list with two elements, mediators and outcomes. These contrast the
values of the mediator and outcomes under the two profiles T and T'.
}
\description{
Given a fitted multimedia model, contrast sampled mediation and outcome data
associated with two treatment profiles.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
model <- multimedia(exper) |>
    estimate(exper)
t1 <- data.frame(treatment = factor("Treatment"))
t2 <- data.frame(treatment = factor("Control"))
profile1 <- setup_profile(model, t1, t1)
profile2 <- setup_profile(model, t2, t2)
contrast_samples(model, profile1, profile2)

samples <- purrr::map(
    seq_len(100),
    ~ contrast_samples(model, profile1, profile2)
)
hist(sapply(samples, \(x) x[[1]]$ASV1))
hist(sapply(samples, \(x) x[[1]]$ASV2))
}
