% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{glmnet_model}
\alias{glmnet_model}
\title{Regularized 'Glmnet' Model across Responses}
\usage{
glmnet_model(progress = TRUE, ...)
}
\arguments{
\item{progress}{A logical indicating whether to show a progress bar during
estimation.}

\item{...}{Keyword parameters passed to package 'glmnet'.}
}
\value{
model An object of class \code{model} with estimator, predictor, and
sampler functions associated wtih a lienar model.
}
\description{
Apply a regularized (generalized) linear model in parallel across each
response $y$ in an outcome or mediation model. This can be helpful when we
have many mediators or pretreatment variables, making the input
high-dimensional.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper, glmnet_model(lambda = 1)) |>
    estimate(exper)

multimedia(exper, glmnet_model(lambda = 1), glmnet_model()) |>
    estimate(exper)

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper, glmnet_model(lambda = 0.1)) |>
    estimate(exper)
}
\seealso{
model lm_model rf_model
}
