% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{retrieve_names}
\alias{retrieve_names}
\title{Variables in a Multimedia Object}
\usage{
retrieve_names(object, nm)
}
\arguments{
\item{object}{An object of class multimedia}

\item{nm}{A string specifying the node type to filter down to, e.g.,
'treatment' or 'mediator'.}
}
\value{
A character vector containing all the names of the variables of the
node type \code{nm}.
}
\description{
This returns all the variables modeled within a multimedia object. This can
be helpful for overviewing an experiment and is called by the print methods
in this package. Also supports filtering to specific node types, e.g.,
mediators.
}
\examples{
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    retrieve_names("mediator")
}
