% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{dlogitnorm}
\alias{dlogitnorm}
\alias{plogitnorm}
\alias{qlogitnorm}
\title{The logit Normal distribution}
\usage{
dlogitnorm(x, mu = 0, sigma = 1, ..., mean, sd)

plogitnorm(q, mu = 0, sigma = 1, ..., mean, sd)

qlogitnorm(p, mu = 0, sigma = 1, ..., mean, sd)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu, sigma}{location and scale parameters, on the logit scale}

\item{...}{additional arguments, passed to \verb{[dpq]norm()}}

\item{mean, sd}{mean and standard deviation, overriding \code{mu} and \code{sigma} if
specified}

\item{p}{vector of probabilities}
}
\value{
Numeric vector of length equal to the maximum of the lengths of the
input arguments.
}
\description{
Density, distribution function, and quantile function for the logit Normal
distribution. The location and scale parameters of the distribution are \code{mu}
and \code{sigma}, which are the mean and standard deviation on the logit scale.
For convenience, the distribution may also be specified in terms of its mean
and standard deviation, instead of its logit-mean and logit-sd.
}
