## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE,results='hide')

## -----------------------------------------------------------------------------
library(musicXML)

## -----------------------------------------------------------------------------
p <- pitch(string='C5') # defines a pitch object

## -----------------------------------------------------------------------------
d <- duration(type=1) # defines a duration object

## -----------------------------------------------------------------------------
l <- 107 # defines loudness of the note

## -----------------------------------------------------------------------------
n <- note(p,d,l) # defines a note object

## -----------------------------------------------------------------------------
n <- note(p=pitch('C5'),d=duration(1),l=107)

## ----results='markup'---------------------------------------------------------
toMXL(n)

## -----------------------------------------------------------------------------
# a quarter G3 played fff
n1 <- note(p=pitch('G3'),d=duration(4),l=140)
# a dotted 8th D4 played f. Note the use of 'dot=TRUE' in duration. There is also a 'triplet=' option.
n2 <- note(p=pitch('D4'),d=duration(8,dot=TRUE),l=100)
# a 16th G4 played mp
n3 <- note(p=pitch('G4'),d=duration(16),l=80)
# two quarter Bb4 played p and tied together (tie2next=TRUE - you could also use tie2previous=TRUE on the second one) 
n4 <- note(p=pitch('Bb4'),d=duration(4),l=60,tie2next=TRUE)
n5 <- note(p=pitch('Bb4'),d=duration(4),l=60)

## -----------------------------------------------------------------------------
# defining a measure. 'number=' is the measure index in the whole score
m <- measure(number=1,notes=list(n1,n2,n3,n4,n5))

## -----------------------------------------------------------------------------
# note the use of 'beats=' and 'beatType=' to modify the time signature
m1 <- measure(number=1,notes=list(n1,n2,n3),beats=2,beatType=4)
m2 <- measure(number=2,notes=list(n4,n5),beats=2,beatType=4)

## -----------------------------------------------------------------------------
# note the use of 'keySignature=' to add flats (negative values) of sharps (positive values) to the key
m1 <- measure(number=1,notes=list(n1,n2,n3),beats=2,beatType=4,keySignature=-3,mode='minor')
m2 <- measure(number=2,notes=list(n4,n5),beats=2,beatType=4,keySignature=-3,mode='minor')

## -----------------------------------------------------------------------------
s <- score(list(m1,m2))

## -----------------------------------------------------------------------------
part1 <- list(m1,m2)
part2 <- list(m2,m2)
s <- score(list(part1,part2))

## -----------------------------------------------------------------------------
writeMXL(s,file='myFirstScore.xml')

## -----------------------------------------------------------------------------
plot(WaggaWagga$Year,WaggaWagga$Precipitation,type='l',xlab='Year',ylab='precip. [mm]')

## -----------------------------------------------------------------------------
plot(WaggaWagga$Year,WaggaWagga$Temperature,type='l',xlab='Year',ylab='temp. [C]')

## -----------------------------------------------------------------------------
# Compute loudnesses from temperatures
llist <- loudnessMapping(WaggaWagga$Temperature,lMin=20,lMax=141)
# Check the relation is just a simple linear interpolation
plot(WaggaWagga$Temperature,llist,pch=19,col=rgb(0,0,0,0.2),xlab='Temp. [C]',ylab='loudness')

## -----------------------------------------------------------------------------
scale <- c("A3", "C4", "D4", "E4", "G4", "A4", "C5", "D5", "E5", "G5")
plist <- pitchMapping(WaggaWagga$Precipitation,pitches=scale)

## -----------------------------------------------------------------------------
# Take a list of pitches/loudnesses and create a list of notes
notes <- getNotes(pitches=plist,loudnesses=llist)

## -----------------------------------------------------------------------------
# Take a list of notes and stack them into a list of measures.
m <- getMeasures(notes=notes,beats=4,beatType=4)

## -----------------------------------------------------------------------------
s <- score(m)
writeMXL(s,file='WaggaWagga.xml')

## ----warning=FALSE,eval=FALSE-------------------------------------------------
#  library(tidyr);library(gganimate)
#  # Modify the shape of the WaggaWagga dataset to facilitate plotting
#  DF <- pivot_longer(WaggaWagga,-Year) # function from tidyr
#  # Plot precipitation and temperature time series using ggplot
#  g <- ggplot(DF,aes(x=Year,y=value))
#  g <- g + geom_line(aes(color=name),size=1)+geom_point(size=4)
#  g <- g + scale_color_manual(values = c('blue','red'),guide=FALSE)
#  g <- g + facet_wrap(vars(name),ncol=1,scales='free_y')
#  # Make it look nicer
#  g <- g+theme_bw()+theme(axis.title=element_text(size=18),
#            axis.text=element_text(size=14),
#            strip.text=element_text(size=18))
#  # Create an animated plot
#  g <- g + transition_reveal(Year)
#  # 'Render' the animated plot into a .mp4 movie
#  bpm=120 # tempo (in beats per minute) used to create the audio file
#  bps=(bpm/60) # convert to beats per second
#  fps=bps*4 # convert to frames per second (there are 4 16th note per beat)
#  animate(g,nframes=NROW(WaggaWagga),fps=fps,width=1280,height=720,
#          renderer = av_renderer('WaggaWaggaMelody.mp4',audio='WaggaWagga.mp3'))

