% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muttest.R
\name{plan}
\alias{plan}
\title{Create a plan for mutation testing}
\usage{
plan(mutators, source_files = fs::dir_ls("R", regexp = ".[rR]$"))
}
\arguments{
\item{mutators}{A list of mutators to use. See \code{\link[=operator]{operator()}}.}

\item{source_files}{A vector of file paths to the source files.}
}
\value{
A data frame with the test plan.
The data frame has the following columns:
\itemize{
\item \code{filename}: The name of the source file.
\item \code{original_code}: The original code of the source file.
\item \code{mutated_code}: The mutated code of the source file.
\item \code{mutator}: The mutator that was applied.
}
}
\description{
Each mutant requires rerunning the tests. For large project it might be not feasible to test all
mutants in one go. This function allows you to create a plan for selected source files and mutators.
}
\details{
The plan is in a data frame format, where each row represents a mutant.

You can subset the plan before passing it to the \code{muttest()} function.
}
