% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_team_contests.R
\name{find_team_contests}
\alias{find_team_contests}
\title{Extract date, opponent, and contest ID for team and season}
\usage{
find_team_contests(team_id = NULL)
}
\arguments{
\item{team_id}{Team ID determined by NCAA for season. To find ID, use
\code{\link[=find_team_id]{find_team_id()}}.}
}
\value{
Returns a data frame that includes date, team, opponent, and contest ID for
each season's contest.
}
\description{
NCAA datasets use a unique ID for each sport, team, season, and match.
This function returns a data frame of dates, opponent team names, and
contest IDs for each NCAA contest (volleyball match) for each team and
season.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
find_team_contests(team_id = "585290")
\dontshow{\}) # examplesIf}
}
