% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{ntimestamp}
\alias{ntimestamp}
\title{neat representation of time stamp}
\usage{
ntimestamp(
  timestamp,
  show_weekday = TRUE,
  show_date = TRUE,
  show_hours = TRUE,
  show_minutes = TRUE,
  show_seconds = TRUE,
  show_timezone = TRUE,
  display_weekday = NULL,
  include_date = NULL,
  include_hours = NULL,
  include_minutes = NULL,
  include_seconds = NULL,
  include_timezone = NULL
)
}
\arguments{
\item{timestamp}{a POSIX time stamp}

\item{show_weekday}{a Boolean representing if the weekday of the timestamp
to be included. By default it is set to TRUE}

\item{show_date}{a Boolean representing if the date of time stamp
to be included. By default it is set to TRUE.}

\item{show_hours}{a Boolean representing if the hours to be included.
By default it is set to TRUE}

\item{show_minutes}{a Boolean representing if the minutes to be included.
By default it is set to TRUE}

\item{show_seconds}{a Boolean representing if the seconds to be included.
By default it is set to TRUE}

\item{show_timezone}{a Boolean variable representing if the
timezone of the date variable to be included. By default it is set to TRUE.}

\item{display_weekday}{Deprecated. Use 'show_weekday' instead.}

\item{include_date}{Deprecated. Use 'show_date' instead.}

\item{include_hours}{Deprecated. Use 'show_hours' instead.}

\item{include_minutes}{Deprecated. Use 'show_minutes' instead.}

\item{include_seconds}{Deprecated. Use 'show_seconds' instead.}

\item{include_timezone}{Deprecated. Use 'show_timezone' instead.}
}
\value{
String representation of time stamp
}
\description{
neat representation of time stamp
}
\examples{
# Neat representation of time stamp
x <- Sys.time()
ntimestamp(x)
# Neat representation of time from a time stamp
ntimestamp(x,
  show_date = FALSE, show_seconds = FALSE,
  show_timezone = FALSE
)
}
