% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neg.semfit.R
\name{neg.semfit}
\alias{neg.semfit}
\title{Equivalence Tests for Fit Indices}
\usage{
neg.semfit(
  mod,
  alpha = 0.05,
  round = 3,
  rmsea.eq.bound = 0.05,
  rmsea.modif.eq.bound = FALSE,
  rmsea.ci.method = "not.close",
  rmsea.nboot = 250L,
  cfi.eq.bound = 0.95,
  cfi.modif.eq.bound = FALSE,
  cfi.ci.method = "yhy.boot",
  cfi.nboot = 250L,
  srmr.eq.bound = 0.08,
  srmr.modif.eq.bound = FALSE,
  srmr.ci.method = "MO",
  usrmr = TRUE,
  srmr.nboot = 250L
)
}
\arguments{
\item{mod}{lavaan model object}

\item{alpha}{desired alpha level (default = .05)}

\item{round}{number of digits to round equivalence bound and confidence interval bounds (default = 3)}

\item{rmsea.eq.bound}{upper bound of the equivalence interval for RMSEA for comparison; must be .01, .05, .08, or .10 if rmsea.modif.eq.bound = TRUE}

\item{rmsea.modif.eq.bound}{should the upper bound of the equivalence interval for RMSEA be modified (default = FALSE)}

\item{rmsea.ci.method}{method used to calculate confidence interval for RMSEA; options are "not.close" or "yhy.boot"; "not.close" corresponds to (1-2alpha) percent CI, "yhy.boot" corresponds to (1-2alpha) percent boot CI (default = "not.close")}

\item{rmsea.nboot}{number of bootstrap samples if "yhy.boot" is selected as rmsea.ci.method (default = 250L)}

\item{cfi.eq.bound}{lower bound of equivalence interval for CFI for comparison; must be .99, .95, .92 or .90 if cfi.modif.eq.bound = TRUE}

\item{cfi.modif.eq.bound}{should the lower bound of the equivalence interval for CFI be modified (default = FALSE)}

\item{cfi.ci.method}{method used to calculate confidence interval for CFI; options are "yuan", "equiv" or "yhy.boot"; "yuan" corresponds to (1-alpha) percent CI, "equiv" corresponds to (1-2alpha) percent CI, "yhy.boot" corresponds to (1-2alpha) percent boot CI (default = "equiv")}

\item{cfi.nboot}{number of bootstrap samples if "yhy.boot" is selected as cfi.ci.method (default = 250L)}

\item{srmr.eq.bound}{upper bound of equivalence interval for SRMR for comparison; must be .05 or .10 if modif.eq.bound = TRUE}

\item{srmr.modif.eq.bound}{should the upper bound of the equivalence interval for SRMR be modified? (default = FALSE)}

\item{srmr.ci.method}{method used to calculate confidence interval for SRMR; options are "MO" or "yhy.boot"; "MO" corresponds to (1-2alpha) percent CI, "yhy.boot" corresponds to (1-2alpha) percent boot CI (default = "MO")}

\item{usrmr}{fit index around which equivalence test should be structured (usrmr = TRUE which is the default states that usrmr from Maydeu-Olivares, 2017 will be used, otherwise srmr from fitmeasures() output in lavaan will be used)}

\item{srmr.nboot}{number of bootstrap samples if "yhy.boot" is selected as srmr.ci.method (default = 250L)}
}
\value{
returns a \code{list} containing analysis and respective statistics
  and decision.
\itemize{
   \item \code{title1} The appropriate title of the test will be displayed depending on the ci.method chosen and whether modif.eq.bound is TRUE or FALSE.
   \item \code{cfi_index} The CFI index.
   \item \code{ci.method} The method for confidence interval calculation.
   \item \code{cfi_eq} The lower end of the confidence interval for the CFI index.
   \item \code{eq.bound} The equivalence bound.
}
}
\description{
Function performs equivalence tests for RMSEA, CFI, and SRMR.
}
\details{
#'
The user specifies the lavaan fitted model object, the desired equivalence bound, and method of confidence interval computation for RMSEA, CFI, and SRMR. By default, the function does not modify the equivalence bounds according to Yuan et al. (2016) or according to Shi et al. (2018). The user can also choose to instead run an equivalence test using a modified equivalence bound if the equivalence bound to be modified is .01, .05, .08, or .10 for RMSEA,.99, .95, .92 or .90 for CFI, .05 or .10 for SRMR.
Alpha level can also be modified.

For information on modified equivalence bounds for CFI and RMSEA see Yuan, K. H., Chan, W., Marcoulides, G. A., & Bentler, P. M. (2016). Assessing structural equation models by equivalence testing with adjusted fit indexes. Structural Equation Modeling: A Multidisciplinary Journal, 23(3), 319-330. doi: https://doi.org/10.1080/10705511.2015.1065414.
For information on uSRMR and modified cut-offs for SRMR see:
Maydeu-Olivares, A. (2017). Maximum likelihood estimation of structural equation models for continuous data: Standard errors and goodness of fit. Structural Equation Modeling: A Multidisciplinary Journal, 24(3), 383-394.
Shi, D., Maydeu-Olivares, A., & DiStefano, C. (2018). The relationship between the standardized root mean square residual and model misspecification in factor analysis models. Multivariate Behavioral Research, 53(5), 676-694.
}
\examples{
d <- lavaan::HolzingerSwineford1939
hs.mod <- 'visual =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed =~ x7 + x8 + x9'
fit1 <- lavaan::cfa(hs.mod, data = d)
neg.cfi(mod = fit1, alpha = .05, eq.bound = .95,  modif.eq.bound = FALSE, ci.method = "equiv",
round = 3, plot = TRUE)

}
\author{
Rob Cribbie \email{cribbie@yorku.ca} and
  Nataly Beribisky \email{natalyb1@yorku.ca}
}
