% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.netmetareg.R
\name{summary.netmetareg}
\alias{summary.netmetareg}
\alias{print.summary.netmetareg}
\title{Summary method for objects of class netmetareg}
\usage{
\method{summary}{netmetareg}(object, ...)

\method{print}{summary.netmetareg}(
  x,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  big.mark = gs("big.mark"),
  ...
)
}
\arguments{
\item{object}{An object of class \code{netmetareg}.}

\item{\dots}{Additional arguments (ignored).}

\item{x}{An object of class \code{summary.netmetareg}.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
errors.}

\item{big.mark}{A character used as thousands separator.}
}
\description{
Summary method for objects of class \code{netmetareg} to print
list of studies in subnetworks.
}
\examples{
\dontrun{
data(smokingcessation)
# Add variable with (fictitious) risk of bias values
# with 1 = "low risk" and 2 = "high risk"
#
smokingcessation$rob <- rep(1:2, 12)

pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

net1 <- netmeta(pw1, common = FALSE, ref = "A")

# Network meta-regression with continuous covariate and assumption of
# independent slopes
nr1 <- netmetareg(net1, rob)
nr1

summary(nr1)
}

}
\seealso{
\code{\link{netmetareg}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
