% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateMetrics.R
\name{calculateMetrics}
\alias{calculateMetrics}
\title{Evaluate SCC or SPM Detection Performance}
\usage{
calculateMetrics(detectedPoints, truePoints, totalCoords, regionName)
}
\arguments{
\item{detectedPoints}{A data frame containing detected coordinates (\code{x}, \code{y}).
SCC-detected points should be obtained using \code{\link{getPoints}}.
SPM-detected points should be obtained using \code{\link{getSPMbinary}}.}

\item{truePoints}{A data frame with ground truth ROI coordinates (\code{x}, \code{y}),
extracted via \code{\link{processROIs}}.}

\item{totalCoords}{A list with the full voxel grid dimensions, created by \code{\link{getDimensions}}.
Must include named elements \code{xDim} and \code{yDim}.}

\item{regionName}{A character string used to label the output region.}
}
\value{
A data frame with the following evaluation metrics
\itemize{
  \item \code{region}: Name of the analyzed region.
  \item \code{sensitivity}: True positive rate (TP / (TP + FN) * 100).
  \item \code{specificity}: True negative rate (TN / (TN + FP) * 100).
  \item \code{PPV}: Positive predictive value (TP / (TP + FP) * 100).
  \item \code{NPV}: Negative predictive value (TN / (TN + FN) * 100).
}
}
\description{
Computes Sensitivity, Specificity, Positive Predictive Value (PPV), and Negative Predictive Value (NPV)
by comparing detected points with ground truth ROI points. This function is used to assess
the accuracy of SCC- or SPM-based detection in neuroimaging analysis.
}
\details{
This function requires three precomputed objects
\itemize{
  \item \code{detectedPoints}: SCC-detected points from \code{\link{getPoints}} or SPM-detected points from \code{\link{getSPMbinary}}.
  \item \code{truePoints}: Ground truth ROIs extracted using \code{\link{processROIs}}.
  \item \code{totalCoords}: Full voxel coordinate grid from \code{\link{getDimensions}}.
}
}
\examples{
# Load precomputed inputs for the example
data("calculateMetricsExample", package = "neuroSCC")

# Evaluate SCC and SPM detection performance
with(calculateMetricsExample, {
  metricsSCC <- calculateMetrics(detectedSCC, trueROI, totalCoords, "Region2_SCC")
  metricsSPM <- calculateMetrics(detectedSPM, trueROI, totalCoords, "Region2_SPM")

  print(metricsSCC)
  print(metricsSPM)
})

}
\seealso{
\code{\link{getPoints}} for SCC-detected regions. \cr
\code{\link{getSPMbinary}} for binary SPM-detected points. \cr
\code{\link{processROIs}} for defining ground truth ROIs. \cr
\code{\link{getDimensions}} for generating the coordinate grid.
}
