% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{as.sparse}
\alias{as.sparse}
\title{Convert to from dense to sparse representation}
\usage{
as.sparse(x, mask, ...)
}
\arguments{
\item{x}{the object to make sparse, e.g. \code{DenseNeuroVol} or \code{DenseNeuroVec}}

\item{mask}{the elements to retain}

\item{...}{additional arguments}
}
\value{
A sparse representation of the input object, containing only the elements specified by \code{mask}.
}
\description{
Convert to from dense to sparse representation
}
\details{
\code{mask} can be an integer vector of 1D indices or a mask volume of class \code{LogicalNeuroVol}
}
\examples{
bvol <- NeuroVol(array(runif(24*24*24), c(24,24,24)), NeuroSpace(c(24,24,24), c(1,1,1)))
indmask <- sort(sample(1:(24*24*24), 100))
svol <- as.sparse(bvol, indmask)


mask <- LogicalNeuroVol(runif(length(indmask)), space=space(bvol), indices=indmask)
sum(mask) == 100
}
