% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/file_format.R
\name{file_matches}
\alias{file_matches}
\alias{file_matches,FileFormat,character-method}
\title{Generic function to test whether a file name conforms to the given \code{\linkS4class{FileFormat}} instance.
Will test for match to either header file or data file}
\usage{
file_matches(x, file_name)

\S4method{file_matches}{FileFormat,character}(x, file_name)
}
\arguments{
\item{x}{A \linkS4class{FileFormat} object specifying the format requirements}

\item{file_name}{A character string specifying the file name to validate}
}
\value{
\code{TRUE} for match, \code{FALSE} otherwise.

A logical value: \code{TRUE} if the file matches the format and both header
  and data files exist, \code{FALSE} otherwise
}
\description{
Validates whether a file name conforms to the specified FileFormat and verifies
the existence of both header and data files.
}
\details{
The function performs the following validation steps:
\enumerate{
  \item Checks if the file name matches either the header or data format
  \item Verifies the existence of the corresponding paired file
  \item Returns \code{FALSE} if either check fails
}

File names are validated using case-sensitive extension matching.
}
\examples{

# Create a FileFormat for NIFTI format
\donttest{
fmt <- new("FileFormat",
  file_format = "NIFTI",
  header_encoding = "raw",
  header_extension = "nii",
  data_encoding = "raw",
  data_extension = "nii")

# Create temporary file
tmp <- tempfile("brainscan", fileext = ".nii")
file.create(tmp)

# Check if files exist and match format
file_matches(fmt, tmp)

# Clean up
unlink(tmp)
}

}
\seealso{
\code{\link{header_file_matches}}, \code{\link{data_file_matches}} for individual
file type checking
}
