% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{lookup}
\alias{lookup}
\title{Index Lookup operation}
\usage{
lookup(x, i, ...)
}
\arguments{
\item{x}{the object to query}

\item{i}{the index to lookup}

\item{...}{additional arguments}
}
\value{
The value(s) at the specified index/indices of \code{x}.
}
\description{
Index Lookup operation
}
\examples{
# Create a 64x64x64 space
space <- NeuroSpace(c(64, 64, 64), c(1, 1, 1), c(0, 0, 0))

# Create a lookup volume with first 100 indices
ilv <- IndexLookupVol(space, 1:100)

# Look up values for indices 1, 2, and 3
# Returns their positions in the sparse representation
lookup(ilv, c(1, 2, 3))

# Look up values outside the included indices
# Returns 0 for indices not in the lookup volume
lookup(ilv, c(101, 102))
}
