% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neuro_obj.R, R/neurospace.R
\name{ndim}
\alias{ndim}
\alias{ndim,NeuroObj-method}
\alias{ndim,NeuroSpace-method}
\title{Extract the number of dimensions of an object}
\usage{
ndim(x, ...)

\S4method{ndim}{NeuroObj}(x)

\S4method{ndim}{NeuroSpace}(x)
}
\arguments{
\item{x}{n-dimensional object}

\item{...}{additional arguments}
}
\value{
An integer representing the number of dimensions in \code{x}.
}
\description{
Extract the number of dimensions of an object
}
\examples{

x = NeuroSpace(c(10,10,10), spacing=c(1,1,1))
ndim(x) == 3
x = NeuroSpace(c(10,10,10,3), spacing=c(1,1,1))
ndim(x) == 4

}
