% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/USREC.R
\docType{data}
\name{USREC}
\alias{USREC}
\title{Recession Indicators Series}
\format{
An \code{\link[xts]{xts}} object containing monthly observations of
NBER-based Recession Indicators.
\describe{
  \item{**Release:**}{Recession Indicators Series (Not a press release)}
  \item{**Seasonal Adjustment:**}{Not Seasonally Adjusted}
  \item{**Frequency:**}{Monthly}
  \item{**Units:**}{Binary indicator (1 = recession, 0 = expansion)}
  \item{**Date Range:**}{1854-12-01 to 2025-07-01}
}
}
\source{
Federal Reserve Bank of St. Louis
\url{https://fred.stlouisfed.org/data/USREC}
}
\usage{
data(USREC)
}
\description{
\code{USREC} NBER based Recession Indicators for the United States from the
period following the peak through the trough.
}
\section{Notes}{

This time series is an interpretation of U.S. Business Cycle Expansions
and Contractions data provided by The National Bureau of Economic
Research (NBER) at \url{http://www.nber.org/cycles/cyclesmain.html}.

The series is composed of dummy variables that represent periods of
expansion and recession. A value of 1 indicates a recessionary period,
while a value of 0 indicates an expansionary period.

The NBER identifies months and quarters of turning points without
designating an exact date within the period that turning points
occurred. For this time series, the recession begins the first day of
the period following a peak and ends on the last day of the period of
the trough.

Three methods of interpretation are used for converting peak/trough
dates into shaded recession data:
\itemize{
  \item Midpoint method — recession spans midpoints of peak and trough.
  \item Trough method — recession spans from period following the peak
        through the trough (used for this series and in FRED).
  \item Peak method — recession spans from peak through the period
        preceding the trough.
}
}

\examples{
data(USREC)
USREC["2007/2009"]
plot(USREC["1947/"], grid.col = "white", col = "red")
}
\keyword{datasets}
