% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_single_point_base.R
\name{calculate_vd}
\alias{calculate_vd}
\title{Calculates volume of distribution from concentration data}
\usage{
calculate_vd(
  dat,
  half_life = NULL,
  dose_type = NULL,
  pooled_ctrl = pooled_control(),
  route = c("bolus", "oral", "infusion")
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{half_life}{Optional numeric value for the drug's half-life.
If not provided, it will be estimated using \code{get_hf()} from pooled
observations.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Required when half_life is not provided. Classified as
first_dose, repeated_doses, or combined_doses based on whether observed
concentrations occur following the first administration, during repeated
dosing, or across both contexts.}

\item{pooled_ctrl}{Optional list of control parameters used by \code{get_pooled_data()}
for pooling observations. Defaults to output from \code{pooled_control()}.}

\item{route}{Character string specifying the route of administration. Must be
one of bolus, oral, or infusion. Currently, oral is not implemented.}
}
\value{
A list with two elements:
\itemize{
\item vd_df: individual volume of distribution estimates
\item trimmed_mean_vd: population volume of distribution estimated as a
trimmed geometric mean using a 5 percent trimming level
}
}
\description{
Calculates the volume of distribution (Vd) using an adaptive single-point approach
}
\details{
The function uses a concentration observed within the first 20\% of the elimination
half-life after dosing as the early point for estimating the volume of distribution.

\deqn{Vd = \frac{\text{Dose}}{C_0}}
For infusion:
\deqn{Vd = \frac{\text{Rate} \times \min(\text{TIME}, \text{durationobs})}{C_0}}

Here, \eqn{C_0} represents the early concentration observed within the first 20\%
of the elimination half-life after dosing, which is used as an approximation of
the initial concentration for estimating volume of distribution (Vd).
\code{TIME} refers to time after dose; \code{durationobs} is the actual infusion duration.

When half_life is not provided, it is estimated from pooled data using
the functions \code{get_pooled_data()} and \code{get_hf()}.
}
\examples{

dat <- Bolus_1CPT
out <- processData(dat)
fdat<- out$dat
froute <-out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Route"]
half_life <- get_hf(dat = fdat)$half_life_median
calculate_vd(dat = fdat, half_life = half_life,route=froute)$trimmed_mean_vd

}
\seealso{
\link{get_pooled_data}, \link{get_hf}, \link{trimmed_geom_mean}
}
\author{
Zhonghui Huang
}
