% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getsigma.R
\name{getsigma}
\alias{getsigma}
\title{Compute overall residual variability from elimination phase}
\usage{
getsigma(df, nlastpoints = 3, sigma_trim = 0.05)
}
\arguments{
\item{df}{Full pharmacokinetic dataset containing at least the columns:
EVID, ID, TIME, DV, and routeobs.}

\item{nlastpoints}{Number of terminal points used for elimination phase
regression in each group (passed to getsigmas).}

\item{sigma_trim}{Trimming proportion used when calculating trimmed means
of residual standard deviations. Default is 0.05.}
}
\value{
A list containing:
\itemize{
\item summary: Named list with trimmed mean values of additive and
proportional residual variability
\item full: Data frame with residual estimates for each individual-dose group
}
}
\description{
Applies \code{getsigmas} to each individual and dose group after filtering
observation records (EVID == 0), and calculates trimmed mean estimates
of additive and proportional residual variability.
}
\details{
The function groups the dataset by subject and dose occasion, applies
elimination-phase residual analysis using \code{getsigmas}, and summarizes the
individual residual standard deviations by their trimmed means. This
provides population-level estimates of additive and proportional residual
unexplained variability (RUV).
}
\examples{
dat <- Bolus_1CPT
dat <- processData(dat)$dat
getsigma(dat)

}
\seealso{
\link{getsigmas}
}
\author{
Zhonghui Huang
}
