% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processData.R
\name{processData}
\alias{processData}
\title{Process time–concentration dataset for pharmacokinetic analysis}
\usage{
processData(dat, verbose = TRUE)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format. The following columns are required (case-insensitive)
and must be present:
\describe{
\item{ID}{Subject identifier (required)}
\item{TIME}{Nominal or actual time after dose (required)}
\item{DV}{Observed concentration (dependent variable) (required)}
\item{EVID}{Event ID indicating observation (0) or dosing event (1) (required)}
\item{AMT}{Dose amount for dosing records (required)}
\item{RATE}{Infusion rate (optional)}
\item{DUR}{Infusion duration (optional)}
\item{MDV}{Missing dependent variable flag (optional)}
\item{CMT}{Compartment number (optional)}
\item{ADDL}{Number of additional doses (optional)}
\item{II}{Interdose interval (optional)}
\item{SS}{Steady-state indicator (optional)}
\item{CENS}{Censoring indicator (optional)}
}}

\item{verbose}{Logical (default = TRUE).
When TRUE, the function prints detailed processing messages and summary
tables to the console, including notes on data cleaning and event handling.
When FALSE, these messages are suppressed and only the returned list is produced.}
}
\value{
A list with two elements:
\itemize{
\item dat: A data frame containing the processed time–concentration dataset
with standardized and derived pharmacokinetic variables, including
resetflag, SSflag, route, dose_number, DVstd, indiv_lambda_z_eligible,
and others.
\item Datainfo: A data frame summarizing the dataset structure, including
subject counts and observation counts for first-dose and multiple-dose
conditions, with contextual notes.
}
}
\description{
Processes a time–concentration dataset to derive analysis-ready variables
and structured output for pharmacokinetic evaluation.
}
\details{
This function standardizes and preprocesses time–concentration data to ensure
compatibility with pharmacokinetic modeling workflows in nlmixr2. The
operations follow these steps:

\enumerate{
\item Standardize data
\itemize{
\item convert column names to uppercase
\item coerce key columns (TIME, DV, EVID, AMT, RATE, etc.) to numeric
}

\item Process events and observations
\itemize{
\item impute EVID from MDV if missing
\item handle censored data (CENS) by converting them to excluded records
\item remove or recode invalid EVID values (e.g., DV = 0 observations)
}

\item Expand dose events
\itemize{
\item expand dosing records using nmpkconvert() when ADDL and II are present
\item assign dose occasions using mark_dose_number()
}

\item Determine administration route and infusion logic
\itemize{
\item derive RATE and DUR when needed
\item identify route (bolus, infusion, oral) based on compartment and rate
}

\item Generate derived variables
\itemize{
\item calculate time after dose using calculate_tad()
\item compute dose-normalized concentration (DVstd)
\item flag eligible records for terminal elimination phase
}

\item Summarize dataset
\itemize{
\item classify dataset as first-dose, repeated-dose, or mixed
\item generate summary metrics for nlmixr2 analysis
}

Classification of dosing context is based on pharmacokinetic observation
records (EVID equal to 0), determining whether observed concentrations
occur after the first dose, during repeated dosing, or across both
contexts. The categories are:

\itemize{
\item first_dose: observations occur only after the initial
administration, without repeated-dose or steady-state intervals.
\item repeated_doses: observations occur only after multiple
administrations or under steady-state conditions.
\item combined_doses: observations include both first-dose and
repeated-dose intervals and are analyzed together.
}
}
}
\examples{
dat <- Bolus_1CPT
processData(dat)

}
\seealso{
\code{\link{nmpkconvert}}, \code{\link{mark_dose_number}}, \code{\link{calculate_tad}}
}
\author{
Zhonghui Huang
}
