% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{fetch_spatial}
\alias{fetch_spatial}
\title{Fetch Spatial Data}
\usage{
fetch_spatial(
  id,
  time = NULL,
  date = NULL,
  geography = NULL,
  select = NULL,
  exclude_missing = FALSE,
  ...,
  parse_sf = TRUE
)
}
\arguments{
\item{id}{Dataset ID}

\item{time}{Time period selection (same as fetch_nomis)}

\item{date}{Specific date selection (alternative to time)}

\item{geography}{Geography code(s) to filter}

\item{select}{Column names to include}

\item{exclude_missing}{Remove missing values if TRUE}

\item{...}{Additional query parameters (measures, sex, etc.)}

\item{parse_sf}{If TRUE and sf is available, parse to sf object}
}
\value{
KML data as text or sf object (if parse_sf = TRUE)
}
\description{
Downloads data in KML format with spatial boundaries.
}
\examples{
\donttest{
spatial_data <- fetch_spatial(
  "NM_1_1",
  time = "latest",
  geography = "TYPE480",
  measures = 20100,
  sex = 7
)
}
}
