% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superset.R
\name{metasuperset}
\alias{metasuperset}
\title{Retrieve Model Outputs with Metadata}
\usage{
metasuperset(
  x,
  groups,
  meta = match.fun("meta")(x, ...),
  subset = getOption("metasuperset_subset", NULL),
  ...
)
}
\arguments{
\item{x}{model name}

\item{groups}{vector of key column names in superset, e.g. USUBJID, TIME}

\item{meta}{metadata with column 'item' and possibly attributes such as 'label' and 'guide'}

\item{subset}{length-one character: a condition for filtering results, e.g. 'EVID == 0'}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Retrieves model outputs with metadata.
}
\examples{
library(magrittr)
options(project = system.file('project/model',package='nonmemica'))
1001 \%>\% metasuperset(c('ID','TIME')) \%>\% head
}
\seealso{
Other superset: 
\code{\link{generalize}()},
\code{\link{ignored}()},
\code{\link{meta}()},
\code{\link{meta.character}()},
\code{\link{meta.numeric}()},
\code{\link{metaplot.character}()},
\code{\link{metaplot.numeric}()},
\code{\link{metaplot_character}()},
\code{\link{ninput}()},
\code{\link{ninput.character}()},
\code{\link{ninput.numeric}()},
\code{\link{shuffle}()},
\code{\link{superset}()},
\code{\link{superset.character}()},
\code{\link{superset.numeric}()},
\code{\link{superspec}()},
\code{\link{superspec.character}()},
\code{\link{superspec.numeric}()}
}
\concept{superset}
